/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.base.MoreObjects;
import com.google.common.base.VerifyException;
import io.airlift.slice.Slice;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.EquatableValueSet;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.expressions.UnboundPredicate;

public final class ExpressionConverter {
    private ExpressionConverter() {
    }

    public static Expression toIcebergExpression(TupleDomain<IcebergColumnHandle> tupleDomain, ConnectorSession session) {
        if (tupleDomain.isAll()) {
            return Expressions.alwaysTrue();
        }
        if (!tupleDomain.getDomains().isPresent()) {
            return Expressions.alwaysFalse();
        }
        Map domainMap = (Map)tupleDomain.getDomains().get();
        True expression = Expressions.alwaysTrue();
        for (Map.Entry entry : domainMap.entrySet()) {
            IcebergColumnHandle columnHandle = (IcebergColumnHandle)entry.getKey();
            Domain domain = (Domain)entry.getValue();
            expression = Expressions.and((Expression)expression, (Expression)ExpressionConverter.toIcebergExpression(columnHandle.getName(), columnHandle.getType(), domain, session));
        }
        return expression;
    }

    private static Expression toIcebergExpression(String columnName, Type type, Domain domain, ConnectorSession session) {
        if (domain.isAll()) {
            return Expressions.alwaysTrue();
        }
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? Expressions.isNull((String)columnName) : Expressions.alwaysFalse();
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? Expressions.alwaysTrue() : Expressions.not((Expression)Expressions.isNull((String)columnName));
        }
        ValueSet domainValues = domain.getValues();
        UnboundPredicate expression = null;
        if (domain.isNullAllowed()) {
            expression = Expressions.isNull((String)columnName);
        }
        if (domainValues instanceof EquatableValueSet) {
            expression = (Expression)MoreObjects.firstNonNull((Object)expression, (Object)Expressions.alwaysFalse());
            EquatableValueSet valueSet = (EquatableValueSet)domainValues;
            if (valueSet.isWhiteList()) {
                return Expressions.or((Expression)expression, (Expression)Expressions.equal((String)columnName, (Object)valueSet.getValues()));
            }
            return Expressions.or((Expression)expression, (Expression)Expressions.notEqual((String)columnName, (Object)valueSet.getValues()));
        }
        if (domainValues instanceof SortedRangeSet) {
            List orderedRanges = ((SortedRangeSet)domainValues).getOrderedRanges();
            expression = (Expression)MoreObjects.firstNonNull((Object)expression, (Object)Expressions.alwaysFalse());
            for (Range range : orderedRanges) {
                Marker low = range.getLow();
                Marker high = range.getHigh();
                Marker.Bound lowBound = low.getBound();
                Marker.Bound highBound = high.getBound();
                if (lowBound == Marker.Bound.EXACTLY && highBound == Marker.Bound.EXACTLY) {
                    if (ExpressionConverter.getValue(type, low, session).equals(ExpressionConverter.getValue(type, high, session))) {
                        expression = Expressions.or((Expression)expression, (Expression)Expressions.equal((String)columnName, (Object)ExpressionConverter.getValue(type, low, session)));
                        continue;
                    }
                    Expression between = Expressions.and((Expression)Expressions.greaterThanOrEqual((String)columnName, (Object)ExpressionConverter.getValue(type, low, session)), (Expression)Expressions.lessThanOrEqual((String)columnName, (Object)ExpressionConverter.getValue(type, high, session)));
                    expression = Expressions.or((Expression)expression, (Expression)between);
                    continue;
                }
                if (lowBound == Marker.Bound.EXACTLY && low.getValueBlock().isPresent()) {
                    expression = Expressions.or((Expression)expression, (Expression)Expressions.greaterThanOrEqual((String)columnName, (Object)ExpressionConverter.getValue(type, low, session)));
                } else if (lowBound == Marker.Bound.ABOVE && low.getValueBlock().isPresent()) {
                    expression = Expressions.or((Expression)expression, (Expression)Expressions.greaterThan((String)columnName, (Object)ExpressionConverter.getValue(type, low, session)));
                }
                if (highBound == Marker.Bound.EXACTLY && high.getValueBlock().isPresent()) {
                    if (low.getValueBlock().isPresent()) {
                        expression = Expressions.and((Expression)expression, (Expression)Expressions.lessThanOrEqual((String)columnName, (Object)ExpressionConverter.getValue(type, high, session)));
                        continue;
                    }
                    expression = Expressions.or((Expression)expression, (Expression)Expressions.lessThanOrEqual((String)columnName, (Object)ExpressionConverter.getValue(type, high, session)));
                    continue;
                }
                if (highBound != Marker.Bound.BELOW || !high.getValueBlock().isPresent()) continue;
                if (low.getValueBlock().isPresent()) {
                    expression = Expressions.and((Expression)expression, (Expression)Expressions.lessThan((String)columnName, (Object)ExpressionConverter.getValue(type, high, session)));
                    continue;
                }
                expression = Expressions.or((Expression)expression, (Expression)Expressions.lessThan((String)columnName, (Object)ExpressionConverter.getValue(type, high, session)));
            }
            return expression;
        }
        throw new VerifyException("Did not expect a domain value set other than SortedRangeSet and EquatableValueSet but got " + domainValues.getClass().getSimpleName());
    }

    private static Object getValue(Type type, Marker marker, ConnectorSession session) {
        if (type instanceof TimestampWithTimeZoneType || type instanceof TimeWithTimeZoneType) {
            return TimeUnit.MILLISECONDS.toMicros(DateTimeEncoding.unpackMillisUtc((long)((Long)marker.getValue())));
        }
        if (type instanceof TimestampType || type instanceof TimeType) {
            return TimeUnit.MILLISECONDS.toMicros((Long)marker.getValue());
        }
        if (type instanceof DateType) {
            return Math.toIntExact((Long)marker.getValue());
        }
        if (type instanceof VarcharType) {
            return ((Slice)marker.getValue()).toStringUtf8();
        }
        if (type instanceof VarbinaryType) {
            return ((Slice)marker.getValue()).getBytes();
        }
        return marker.getValue();
    }
}

