/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.plugin.iceberg.IcebergUtil;
import io.prestosql.plugin.iceberg.util.PageListBuilder;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class FilesTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;

    public FilesTable(SchemaTableName tableName, Table icebergTable, Optional<Long> snapshotId, TypeManager typeManager) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("file_path", (io.prestosql.spi.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("file_format", (io.prestosql.spi.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("record_count", (io.prestosql.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("file_size_in_bytes", (io.prestosql.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("column_sizes", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("value_counts", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("null_value_counts", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)BigintType.BIGINT.getTypeSignature())))).add((Object)new ColumnMetadata("lower_bounds", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).add((Object)new ColumnMetadata("upper_bounds", typeManager.getType(TypeSignature.mapType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).add((Object)new ColumnMetadata("key_metadata", (io.prestosql.spi.type.Type)VarbinaryType.VARBINARY)).add((Object)new ColumnMetadata("split_offsets", (io.prestosql.spi.type.Type)new ArrayType((io.prestosql.spi.type.Type)BigintType.BIGINT))).build());
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(FilesTable.buildPages(this.tableMetadata, session, this.icebergTable, this.snapshotId));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, ConnectorSession session, Table icebergTable, Optional<Long> snapshotId) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        TableScan tableScan = IcebergUtil.getTableScan(session, (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), snapshotId, icebergTable).includeColumnStats();
        Map idToTypeMapping = (Map)icebergTable.schema().columns().stream().collect(ImmutableMap.toImmutableMap(Types.NestedField::fieldId, column -> column.type().asPrimitiveType()));
        tableScan.planFiles().forEach(fileScanTask -> {
            DataFile dataFile = fileScanTask.file();
            pagesBuilder.beginRow();
            pagesBuilder.appendVarchar(dataFile.path().toString());
            pagesBuilder.appendVarchar(dataFile.format().name());
            pagesBuilder.appendBigint(dataFile.recordCount());
            pagesBuilder.appendBigint(dataFile.fileSizeInBytes());
            if (FilesTable.checkNonNull(dataFile.columnSizes(), pagesBuilder)) {
                pagesBuilder.appendIntegerBigintMap(dataFile.columnSizes());
            }
            if (FilesTable.checkNonNull(dataFile.valueCounts(), pagesBuilder)) {
                pagesBuilder.appendIntegerBigintMap(dataFile.valueCounts());
            }
            if (FilesTable.checkNonNull(dataFile.nullValueCounts(), pagesBuilder)) {
                pagesBuilder.appendIntegerBigintMap(dataFile.nullValueCounts());
            }
            if (FilesTable.checkNonNull(dataFile.lowerBounds(), pagesBuilder)) {
                pagesBuilder.appendIntegerVarcharMap((Map)dataFile.lowerBounds().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Transforms.identity((Type)((Type)idToTypeMapping.get(entry.getKey()))).toHumanString(Conversions.fromByteBuffer((Type)((Type)idToTypeMapping.get(entry.getKey())), (ByteBuffer)((ByteBuffer)entry.getValue()))))));
            }
            if (FilesTable.checkNonNull(dataFile.upperBounds(), pagesBuilder)) {
                pagesBuilder.appendIntegerVarcharMap((Map)dataFile.upperBounds().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Transforms.identity((Type)((Type)idToTypeMapping.get(entry.getKey()))).toHumanString(Conversions.fromByteBuffer((Type)((Type)idToTypeMapping.get(entry.getKey())), (ByteBuffer)((ByteBuffer)entry.getValue()))))));
            }
            if (FilesTable.checkNonNull(dataFile.keyMetadata(), pagesBuilder)) {
                pagesBuilder.appendVarbinary(Slices.wrappedBuffer((ByteBuffer)dataFile.keyMetadata()));
            }
            if (FilesTable.checkNonNull(dataFile.splitOffsets(), pagesBuilder)) {
                pagesBuilder.appendBigintArray(dataFile.splitOffsets());
            }
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }

    private static boolean checkNonNull(Object object, PageListBuilder pagesBuilder) {
        if (object == null) {
            pagesBuilder.appendNull();
            return false;
        }
        return true;
    }
}

