/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;

public class HdfsFileIo
implements FileIO {
    private final HdfsEnvironment environment;
    private final HdfsEnvironment.HdfsContext context;

    public HdfsFileIo(HdfsEnvironment environment, HdfsEnvironment.HdfsContext context) {
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
    }

    public InputFile newInputFile(String path) {
        Configuration configuration = this.environment.getConfiguration(this.context, new Path(path));
        return HadoopInputFile.fromLocation((CharSequence)path, (Configuration)configuration);
    }

    public OutputFile newOutputFile(String path) {
        Configuration configuration = this.environment.getConfiguration(this.context, new Path(path));
        return HadoopOutputFile.fromPath((Path)new Path(path), (Configuration)configuration);
    }

    public void deleteFile(String pathString) {
        Path path = new Path(pathString);
        try {
            this.environment.getFileSystem(this.context, path).delete(path, false);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to delete file: " + path, (Throwable)e);
        }
    }
}

