/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.SnapshotUtil;

public class HistoryTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private static final List<ColumnMetadata> COLUMNS = ImmutableList.builder().add((Object)new ColumnMetadata("made_current_at", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)).add((Object)new ColumnMetadata("snapshot_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("parent_id", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("is_current_ancestor", (Type)BooleanType.BOOLEAN)).build();

    public HistoryTable(SchemaTableName tableName, Table icebergTable) {
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), COLUMNS);
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder(COLUMNS);
        ImmutableSet ancestorIds = ImmutableSet.copyOf((Collection)SnapshotUtil.currentAncestors((Table)this.icebergTable));
        TimeZoneKey timeZoneKey = session.getTimeZoneKey();
        for (HistoryEntry historyEntry : this.icebergTable.history()) {
            long snapshotId = historyEntry.snapshotId();
            Snapshot snapshot = this.icebergTable.snapshot(snapshotId);
            table.addRow(new Object[]{DateTimeEncoding.packDateTimeWithZone((long)historyEntry.timestampMillis(), (TimeZoneKey)timeZoneKey), snapshotId, snapshot != null ? snapshot.parentId() : null, ancestorIds.contains(snapshotId)});
        }
        return table.build().cursor();
    }
}

