/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.iceberg.HdfsFileIo;
import io.prestosql.plugin.iceberg.IcebergErrorCode;
import io.prestosql.plugin.iceberg.IcebergUtil;
import io.prestosql.plugin.iceberg.UnknownTableTypeException;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.ConnectorIdentity;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.hive.HiveTypeConverter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Tasks;

@NotThreadSafe
public class HiveTableOperations
implements TableOperations {
    private static final Logger log = Logger.get(HiveTableOperations.class);
    public static final String METADATA_LOCATION = "metadata_location";
    public static final String PREVIOUS_METADATA_LOCATION = "previous_metadata_location";
    private static final String METADATA_FOLDER_NAME = "metadata";
    private static final StorageFormat STORAGE_FORMAT = StorageFormat.create((String)LazySimpleSerDe.class.getName(), (String)FileInputFormat.class.getName(), (String)FileOutputFormat.class.getName());
    private final HiveMetastore metastore;
    private final HiveIdentity identity;
    private final String database;
    private final String tableName;
    private final Optional<String> owner;
    private final Optional<String> location;
    private final FileIO fileIo;
    private TableMetadata currentMetadata;
    private String currentMetadataLocation;
    private boolean shouldRefresh = true;
    private int version = -1;

    public HiveTableOperations(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, String database, String table) {
        this(new HdfsFileIo(hdfsEnvironment, hdfsContext), metastore, identity, database, table, Optional.empty(), Optional.empty());
    }

    public HiveTableOperations(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext hdfsContext, HiveIdentity identity, String database, String table, String owner, String location) {
        this(new HdfsFileIo(hdfsEnvironment, hdfsContext), metastore, identity, database, table, Optional.of(Objects.requireNonNull(owner, "owner is null")), Optional.of(Objects.requireNonNull(location, "location is null")));
    }

    private HiveTableOperations(FileIO fileIo, HiveMetastore metastore, HiveIdentity identity, String database, String table, Optional<String> owner, Optional<String> location) {
        this.fileIo = Objects.requireNonNull(fileIo, "fileIo is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.database = Objects.requireNonNull(database, "database is null");
        this.tableName = Objects.requireNonNull(table, "table is null");
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.location = Objects.requireNonNull(location, "location is null");
    }

    public TableMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    public TableMetadata refresh() {
        if (this.location.isPresent()) {
            this.refreshFromMetadataLocation(null);
            return this.currentMetadata;
        }
        Table table = this.getTable();
        if (!IcebergUtil.isIcebergTable(table)) {
            throw new UnknownTableTypeException(this.getSchemaTableName());
        }
        String metadataLocation = (String)table.getParameters().get(METADATA_LOCATION);
        if (metadataLocation == null) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table is missing [%s] property: %s", METADATA_LOCATION, this.getSchemaTableName()));
        }
        this.refreshFromMetadataLocation(metadataLocation);
        return this.currentMetadata;
    }

    public void commit(@Nullable TableMetadata base, TableMetadata metadata) {
        Table table;
        Objects.requireNonNull(metadata, "metadata is null");
        if (!Objects.equals(base, this.current())) {
            throw new CommitFailedException("Cannot commit: stale table metadata for %s", new Object[]{this.getSchemaTableName()});
        }
        if (Objects.equals(base, metadata)) {
            return;
        }
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version + 1);
        try {
            if (base == null) {
                table = Table.builder().setDatabaseName(this.database).setTableName(this.tableName).setOwner(this.owner.orElseThrow(() -> new IllegalStateException("Owner not set"))).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns(HiveTableOperations.toHiveColumns(metadata.schema().columns())).withStorage(storage -> storage.setLocation(metadata.location())).withStorage(storage -> storage.setStorageFormat(STORAGE_FORMAT)).setParameter("EXTERNAL", "TRUE").setParameter("table_type", "iceberg").setParameter(METADATA_LOCATION, newMetadataLocation).build();
            } else {
                Table currentTable = this.getTable();
                Preconditions.checkState((this.currentMetadataLocation != null ? 1 : 0) != 0, (Object)"No current metadata location for existing table");
                String metadataLocation = (String)currentTable.getParameters().get(METADATA_LOCATION);
                if (!this.currentMetadataLocation.equals(metadataLocation)) {
                    throw new CommitFailedException("Metadata location [%s] is not same as table metadata location [%s] for %s", new Object[]{this.currentMetadataLocation, metadataLocation, this.getSchemaTableName()});
                }
                table = Table.builder((Table)currentTable).setDataColumns(HiveTableOperations.toHiveColumns(metadata.schema().columns())).withStorage(storage -> storage.setLocation(metadata.location())).setParameter(METADATA_LOCATION, newMetadataLocation).setParameter(PREVIOUS_METADATA_LOCATION, this.currentMetadataLocation).build();
            }
        }
        catch (RuntimeException e) {
            try {
                this.io().deleteFile(newMetadataLocation);
            }
            catch (RuntimeException ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
        PrincipalPrivileges privileges = MetastoreUtil.buildInitialPrivilegeSet((String)table.getOwner());
        ConnectorIdentity identity = ConnectorIdentity.ofUser((String)table.getOwner());
        HiveIdentity context = new HiveIdentity(identity);
        if (base == null) {
            this.metastore.createTable(context, table, privileges);
        } else {
            this.metastore.replaceTable(context, this.database, this.tableName, table, privileges);
        }
        this.shouldRefresh = true;
    }

    public FileIO io() {
        return this.fileIo;
    }

    public String metadataFileLocation(String filename) {
        String location;
        TableMetadata metadata = this.current();
        if (metadata != null) {
            String writeLocation = (String)metadata.properties().get("write.metadata.path");
            if (writeLocation != null) {
                return String.format("%s/%s", writeLocation, filename);
            }
            location = metadata.location();
        } else {
            location = this.location.orElseThrow(() -> new IllegalStateException("Location not set"));
        }
        return String.format("%s/%s/%s", location, METADATA_FOLDER_NAME, filename);
    }

    public LocationProvider locationProvider() {
        TableMetadata metadata = this.current();
        return LocationProviders.locationsFor((String)metadata.location(), (Map)metadata.properties());
    }

    private Table getTable() {
        return (Table)this.metastore.getTable(this.identity, this.database, this.tableName).orElseThrow(() -> new TableNotFoundException(this.getSchemaTableName()));
    }

    private SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.database, this.tableName);
    }

    private String writeNewMetadata(TableMetadata metadata, int newVersion) {
        String newTableMetadataFilePath = HiveTableOperations.newTableMetadataFilePath(metadata, newVersion);
        OutputFile newMetadataLocation = this.fileIo.newOutputFile(newTableMetadataFilePath);
        TableMetadataParser.write((TableMetadata)metadata, (OutputFile)newMetadataLocation);
        return newTableMetadataFilePath;
    }

    private void refreshFromMetadataLocation(String newLocation) {
        if (Objects.equals(this.currentMetadataLocation, newLocation)) {
            this.shouldRefresh = false;
            return;
        }
        AtomicReference newMetadata = new AtomicReference();
        Tasks.foreach((Object[])new String[]{newLocation}).retry(20).exponentialBackoff(100L, 5000L, 600000L, 4.0).suppressFailureWhenFinished().run(metadataLocation -> newMetadata.set(TableMetadataParser.read((TableOperations)this, (InputFile)this.io().newInputFile(metadataLocation))));
        String newUUID = ((TableMetadata)newMetadata.get()).uuid();
        if (this.currentMetadata != null) {
            Preconditions.checkState((newUUID == null || newUUID.equals(this.currentMetadata.uuid()) ? 1 : 0) != 0, (String)"Table UUID does not match: current=%s != refreshed=%s", (Object)this.currentMetadata.uuid(), (Object)newUUID);
        }
        this.currentMetadata = (TableMetadata)newMetadata.get();
        this.currentMetadataLocation = newLocation;
        this.version = HiveTableOperations.parseVersion(newLocation);
        this.shouldRefresh = false;
    }

    private static String newTableMetadataFilePath(TableMetadata meta, int newVersion) {
        String codec = meta.property("write.metadata.compression-codec", "none");
        return HiveTableOperations.metadataFileLocation(meta, String.format("%05d-%s%s", newVersion, UUID.randomUUID(), TableMetadataParser.getFileExtension((String)codec)));
    }

    private static String metadataFileLocation(TableMetadata metadata, String filename) {
        String location = (String)metadata.properties().get("write.metadata.path");
        if (location != null) {
            return String.format("%s/%s", location, filename);
        }
        return String.format("%s/%s/%s", metadata.location(), METADATA_FOLDER_NAME, filename);
    }

    private static int parseVersion(String metadataLocation) {
        int versionStart = metadataLocation.lastIndexOf(47) + 1;
        int versionEnd = metadataLocation.indexOf(45, versionStart);
        try {
            return Integer.parseInt(metadataLocation.substring(versionStart, versionEnd));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            log.warn((Throwable)e, "Unable to parse version from metadata location: %s", new Object[]{metadataLocation});
            return -1;
        }
    }

    private static List<Column> toHiveColumns(List<Types.NestedField> columns) {
        return (List)columns.stream().map(column -> new Column(column.name(), HiveType.valueOf((String)HiveTypeConverter.convert((Type)column.type())), Optional.empty())).collect(ImmutableList.toImmutableList());
    }
}

