/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public class IcebergColumnHandle
implements ColumnHandle {
    private final int id;
    private final String name;
    private final Type type;
    private final Optional<String> comment;

    @JsonCreator
    public IcebergColumnHandle(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="comment") Optional<String> comment) {
        this.id = id;
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @JsonProperty
    public int getId() {
        return this.id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.type, this.comment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IcebergColumnHandle other = (IcebergColumnHandle)obj;
        return this.id == other.id && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.comment, other.comment);
    }

    public String toString() {
        return this.id + ":" + this.name + ":" + this.type.getDisplayName();
    }
}

