/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import io.airlift.configuration.Config;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.iceberg.IcebergFileFormat;
import javax.validation.constraints.Min;
import org.apache.iceberg.FileFormat;

public class IcebergConfig {
    private long metastoreTransactionCacheSize = 1000L;
    private IcebergFileFormat fileFormat = IcebergFileFormat.ORC;
    private HiveCompressionCodec compressionCodec = HiveCompressionCodec.GZIP;

    @Min(value=1L)
    public @Min(value=1L) long getMetastoreTransactionCacheSize() {
        return this.metastoreTransactionCacheSize;
    }

    @Config(value="iceberg.metastore.transaction-cache.size")
    public IcebergConfig setMetastoreTransactionCacheSize(long metastoreTransactionCacheSize) {
        this.metastoreTransactionCacheSize = metastoreTransactionCacheSize;
        return this;
    }

    public FileFormat getFileFormat() {
        return FileFormat.valueOf((String)this.fileFormat.name());
    }

    @Config(value="iceberg.file-format")
    public IcebergConfig setFileFormat(IcebergFileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @Config(value="iceberg.compression-codec")
    public IcebergConfig setCompressionCodec(HiveCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }
}

