/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.orc.OrcDataSink;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.orc.OrcWriterOptions;
import io.prestosql.orc.OrcWriterStats;
import io.prestosql.orc.OutputStreamOrcDataSink;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.FileWriter;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.RecordFileWriter;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.orc.HdfsOrcDataSource;
import io.prestosql.plugin.hive.orc.OrcFileWriter;
import io.prestosql.plugin.hive.orc.OrcWriterConfig;
import io.prestosql.plugin.hive.util.ParquetRecordWriterUtil;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.plugin.iceberg.IcebergErrorCode;
import io.prestosql.plugin.iceberg.IcebergSessionProperties;
import io.prestosql.plugin.iceberg.TypeConverter;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class IcebergFileWriterFactory {
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final NodeVersion nodeVersion;
    private final FileFormatDataSourceStats readStats;
    private final OrcWriterStats orcWriterStats = new OrcWriterStats();
    private final OrcWriterOptions orcWriterOptions;

    @Inject
    public IcebergFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, FileFormatDataSourceStats readStats, OrcWriterConfig orcWriterConfig) {
        Preconditions.checkArgument((!Objects.requireNonNull(orcWriterConfig, "orcWriterConfig is null").isUseLegacyVersion() ? 1 : 0) != 0, (Object)"the ORC writer shouldn't be configured to use a legacy version");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.readStats = Objects.requireNonNull(readStats, "readStats is null");
        this.orcWriterOptions = orcWriterConfig.toOrcWriterOptions();
    }

    @Managed
    @Flatten
    public OrcWriterStats getOrcWriterStats() {
        return this.orcWriterStats;
    }

    public FileWriter createFileWriter(Path outputPath, Schema icebergSchema, List<IcebergColumnHandle> columns, JobConf jobConf, ConnectorSession session, FileFormat fileFormat) {
        switch (fileFormat) {
            case PARQUET: {
                return this.createParquetWriter(outputPath, icebergSchema, columns, jobConf, session);
            }
            case ORC: {
                return this.createOrcWriter(outputPath, icebergSchema, jobConf, session);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "File format not supported for Iceberg: " + fileFormat);
    }

    private FileWriter createParquetWriter(Path outputPath, Schema icebergSchema, List<IcebergColumnHandle> columns, JobConf jobConf, ConnectorSession session) {
        Properties properties = new Properties();
        properties.setProperty("columns", columns.stream().map(IcebergColumnHandle::getName).collect(Collectors.joining(",")));
        properties.setProperty("columns.types", columns.stream().map(column -> TypeConverter.toHiveType(column.getType()).getHiveTypeName().toString()).collect(Collectors.joining(":")));
        ParquetRecordWriterUtil.setParquetSchema((Configuration)jobConf, (MessageType)ParquetSchemaUtil.convert((Schema)icebergSchema, (String)"table"));
        jobConf.set("parquet.compression", IcebergSessionProperties.getCompressionCodec(session).getParquetCompressionCodec().name());
        return new RecordFileWriter(outputPath, (List)columns.stream().map(IcebergColumnHandle::getName).collect(ImmutableList.toImmutableList()), StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.PARQUET), properties, HiveStorageFormat.PARQUET.getEstimatedWriterSystemMemoryUsage(), jobConf, this.typeManager, session);
    }

    private FileWriter createOrcWriter(Path outputPath, Schema icebergSchema, JobConf jobConf, ConnectorSession session) {
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getUser(), outputPath, (Configuration)jobConf);
            OutputStreamOrcDataSink orcDataSink = new OutputStreamOrcDataSink((OutputStream)fileSystem.create(outputPath));
            Callable<Void> rollbackAction = () -> {
                fileSystem.delete(outputPath, false);
                return null;
            };
            List columnFields = icebergSchema.columns();
            List fileColumnNames = (List)columnFields.stream().map(Types.NestedField::name).collect(ImmutableList.toImmutableList());
            List fileColumnTypes = (List)columnFields.stream().map(Types.NestedField::type).map(type -> TypeConverter.toPrestoType(type, this.typeManager)).collect(ImmutableList.toImmutableList());
            Optional<Object> validationInputFactory = Optional.empty();
            if (IcebergSessionProperties.isOrcWriterValidate(session)) {
                validationInputFactory = Optional.of(() -> {
                    try {
                        return new HdfsOrcDataSource(new OrcDataSourceId(outputPath.toString()), fileSystem.getFileStatus(outputPath).getLen(), new OrcReaderOptions(), fileSystem.open(outputPath), this.readStats);
                    }
                    catch (IOException e) {
                        throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITE_VALIDATION_FAILED, (Throwable)e);
                    }
                });
            }
            return new OrcFileWriter((OrcDataSink)orcDataSink, rollbackAction, fileColumnNames, fileColumnTypes, TypeConverter.toOrcType(icebergSchema), IcebergSessionProperties.getCompressionCodec(session).getOrcCompressionKind(), this.orcWriterOptions.withStripeMinSize(IcebergSessionProperties.getOrcWriterMinStripeSize(session)).withStripeMaxSize(IcebergSessionProperties.getOrcWriterMaxStripeSize(session)).withStripeMaxRowCount(IcebergSessionProperties.getOrcWriterMaxStripeRows(session)).withDictionaryMaxMemory(IcebergSessionProperties.getOrcWriterMaxDictionaryMemory(session)).withMaxStringStatisticsLimit(IcebergSessionProperties.getOrcStringStatisticsLimit(session)), false, IntStream.range(0, fileColumnNames.size()).toArray(), (Map)ImmutableMap.builder().put((Object)"presto_version", (Object)this.nodeVersion.toString()).put((Object)"presto_query_id", (Object)session.getQueryId()).build(), DateTimeZone.UTC, validationInputFactory, IcebergSessionProperties.getOrcWriterValidateMode(session), this.orcWriterStats);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_OPEN_ERROR, "Error creating ORC file", (Throwable)e);
        }
    }
}

