/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeSystemTable;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveSchemaProperties;
import io.prestosql.plugin.hive.HiveWrittenPartitions;
import io.prestosql.plugin.hive.TableAlreadyExistsException;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.HiveWriteUtils;
import io.prestosql.plugin.iceberg.CommitTaskData;
import io.prestosql.plugin.iceberg.DomainConverter;
import io.prestosql.plugin.iceberg.ExpressionConverter;
import io.prestosql.plugin.iceberg.FilesTable;
import io.prestosql.plugin.iceberg.HistoryTable;
import io.prestosql.plugin.iceberg.HiveTableOperations;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.plugin.iceberg.IcebergInputInfo;
import io.prestosql.plugin.iceberg.IcebergSchemaProperties;
import io.prestosql.plugin.iceberg.IcebergTableHandle;
import io.prestosql.plugin.iceberg.IcebergTableProperties;
import io.prestosql.plugin.iceberg.IcebergUtil;
import io.prestosql.plugin.iceberg.IcebergWritableTableHandle;
import io.prestosql.plugin.iceberg.ManifestsTable;
import io.prestosql.plugin.iceberg.PartitionData;
import io.prestosql.plugin.iceberg.PartitionFields;
import io.prestosql.plugin.iceberg.PartitionTable;
import io.prestosql.plugin.iceberg.SnapshotsTable;
import io.prestosql.plugin.iceberg.TableType;
import io.prestosql.plugin.iceberg.TypeConverter;
import io.prestosql.plugin.iceberg.UnknownTableTypeException;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class IcebergMetadata
implements ConnectorMetadata {
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private Transaction transaction;

    public IcebergMetadata(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskCodec) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases();
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, CatalogSchemaName schemaName) {
        Optional db = this.metastore.getDatabase(schemaName.getSchemaName());
        if (db.isPresent()) {
            return HiveSchemaProperties.fromDatabase((Database)((Database)db.get()));
        }
        throw new SchemaNotFoundException(schemaName.getSchemaName());
    }

    public Optional<PrestoPrincipal> getSchemaOwner(ConnectorSession session, CatalogSchemaName schemaName) {
        Optional database = this.metastore.getDatabase(schemaName.getSchemaName());
        if (database.isPresent()) {
            return database.flatMap(db -> Optional.of(new PrestoPrincipal(db.getOwnerType(), db.getOwnerName())));
        }
        throw new SchemaNotFoundException(schemaName.getSchemaName());
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        IcebergTableHandle handle = IcebergTableHandle.from(tableName);
        Optional table = this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName());
        if (!table.isPresent()) {
            return null;
        }
        if (handle.getTableType() != TableType.DATA) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table type not yet supported: " + handle.getSchemaTableNameWithType());
        }
        if (!IcebergUtil.isIcebergTable((Table)table.get())) {
            throw new UnknownTableTypeException(tableName);
        }
        return handle;
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        IcebergTableHandle table = IcebergTableHandle.from(tableName);
        return this.getRawSystemTable(session, table).map(systemTable -> new ClassLoaderSafeSystemTable(systemTable, this.getClass().getClassLoader()));
    }

    private Optional<SystemTable> getRawSystemTable(ConnectorSession session, IcebergTableHandle table) {
        org.apache.iceberg.Table icebergTable = IcebergUtil.getIcebergTable(this.metastore, this.hdfsEnvironment, session, table.getSchemaTableName());
        switch (table.getTableType()) {
            case PARTITIONS: {
                return Optional.of(new PartitionTable(table, this.typeManager, icebergTable));
            }
            case HISTORY: {
                return Optional.of(new HistoryTable(table.getSchemaTableNameWithType(), icebergTable));
            }
            case SNAPSHOTS: {
                return Optional.of(new SnapshotsTable(table.getSchemaTableNameWithType(), this.typeManager, icebergTable));
            }
            case MANIFESTS: {
                return Optional.of(new ManifestsTable(table.getSchemaTableNameWithType(), icebergTable, table.getSnapshotId()));
            }
            case FILES: {
                return Optional.of(new FilesTable(table.getSchemaTableNameWithType(), icebergTable, table.getSnapshotId(), this.typeManager));
            }
        }
        return Optional.empty();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new ConnectorTableProperties();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableMetadata(session, ((IcebergTableHandle)table).getSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return schemaName.map(Collections::singletonList).orElseGet(() -> ((HiveMetastore)this.metastore).getAllDatabases()).stream().flatMap(schema -> this.metastore.getTablesWithParameter(schema, "table_type", "iceberg").stream().map(table -> new SchemaTableName(schema, table)).collect(Collectors.toList()).stream()).collect(Collectors.toList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        org.apache.iceberg.Table icebergTable = IcebergUtil.getIcebergTable(this.metastore, this.hdfsEnvironment, session, table.getSchemaTableName());
        return (Map)IcebergUtil.getColumns(icebergTable.schema(), this.typeManager).stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getName, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setComment(column.getComment()).build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        List tables = prefix.getTable().map(ignored -> Collections.singletonList(prefix.toSchemaTableName())).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName table : tables) {
            try {
                columns.put((Object)table, (Object)this.getTableMetadata(session, table).getColumns());
            }
            catch (TableNotFoundException tableNotFoundException) {
            }
            catch (UnknownTableTypeException unknownTableTypeException) {}
        }
        return columns.build();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, PrestoPrincipal owner) {
        Optional<String> location = IcebergSchemaProperties.getSchemaLocation(properties).map(uri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, schemaName), new Path(uri));
            }
            catch (IOException | IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + uri, (Throwable)e);
            }
            return uri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(owner.getType()).setOwnerName(owner.getName()).build();
        this.metastore.createDatabase(new HiveIdentity(session), database);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        if (!this.listTables(session, Optional.of(schemaName)).isEmpty() || !this.listViews(session, Optional.of(schemaName)).isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        this.metastore.dropDatabase(new HiveIdentity(session), schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(new HiveIdentity(session), source, target);
    }

    public void setSchemaAuthorization(ConnectorSession session, String source, PrestoPrincipal principal) {
        this.metastore.setDatabaseOwner(new HiveIdentity(session), source, HivePrincipal.from((PrestoPrincipal)principal));
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Optional layout = this.getNewTableLayout(session, tableMetadata);
        this.finishCreateTable(session, this.beginCreateTable(session, tableMetadata, layout), (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        HiveTableOperations operations;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Schema schema = IcebergMetadata.toIcebergSchema(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        Database database = (Database)this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, schemaName, tableName);
        HiveIdentity identity = new HiveIdentity(session);
        String targetPath = IcebergTableProperties.getTableLocation(tableMetadata.getProperties());
        if (targetPath == null) {
            targetPath = HiveWriteUtils.getTableDefaultLocation((Database)database, (HdfsEnvironment.HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (String)schemaName, (String)tableName).toString();
        }
        if ((operations = new HiveTableOperations(this.metastore, this.hdfsEnvironment, hdfsContext, identity, schemaName, tableName, session.getUser(), targetPath)).current() != null) {
            throw new TableAlreadyExistsException(schemaTableName);
        }
        FileFormat fileFormat = IcebergTableProperties.getFileFormat(tableMetadata.getProperties());
        TableMetadata metadata = TableMetadata.newTableMetadata((TableOperations)operations, (Schema)schema, (PartitionSpec)partitionSpec, (String)targetPath, (Map)ImmutableMap.of((Object)"write.format.default", (Object)fileFormat.toString()));
        this.transaction = Transactions.createTableTransaction((TableOperations)operations, (TableMetadata)metadata);
        return new IcebergWritableTableHandle(schemaName, tableName, SchemaParser.toJson((Schema)metadata.schema()), PartitionSpecParser.toJson((PartitionSpec)metadata.spec()), IcebergUtil.getColumns(metadata.schema(), this.typeManager), targetPath, fileFormat);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return this.finishInsert(session, (IcebergWritableTableHandle)tableHandle, fragments, computedStatistics);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        org.apache.iceberg.Table icebergTable = IcebergUtil.getIcebergTable(this.metastore, this.hdfsEnvironment, session, table.getSchemaTableName());
        for (Types.NestedField column : icebergTable.schema().columns()) {
            io.prestosql.spi.type.Type type = TypeConverter.toPrestoType(column.type(), this.typeManager);
            if (type instanceof DecimalType) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to columns of type decimal not yet supported");
            }
            if (!(type instanceof TimestampType)) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to columns of type timestamp not yet supported");
        }
        this.transaction = icebergTable.newTransaction();
        return new IcebergWritableTableHandle(table.getSchemaName(), table.getTableName(), SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), this.typeManager), IcebergUtil.getDataPath(icebergTable.location()), IcebergUtil.getFileFormat(icebergTable));
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        org.apache.iceberg.Table icebergTable = this.transaction.table();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = this.transaction.newFastAppend();
        for (CommitTaskData task : commitTasks) {
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, table.getSchemaName(), table.getTableName());
            Configuration configuration = this.hdfsEnvironment.getConfiguration(context, new Path(task.getPath()));
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withInputFile((InputFile)HadoopInputFile.fromLocation((CharSequence)task.getPath(), (Configuration)configuration)).withFormat(table.getFileFormat()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
        }
        appendFiles.commit();
        this.transaction.commitTransaction();
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::getPath).collect(ImmutableList.toImmutableList())));
    }

    public Optional<Object> getInfo(ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        return Optional.of(new IcebergInputInfo(table.getSnapshotId()));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        this.metastore.dropTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName(), true);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        this.metastore.renameTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName(), newTable.getSchemaName(), newTable.getTableName());
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        org.apache.iceberg.Table icebergTable = IcebergUtil.getIcebergTable(this.metastore, this.hdfsEnvironment, session, handle.getSchemaTableName());
        icebergTable.updateSchema().addColumn(column.getName(), TypeConverter.toIcebergType(column.getType())).commit();
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        org.apache.iceberg.Table icebergTable = IcebergUtil.getIcebergTable(this.metastore, this.hdfsEnvironment, session, icebergTableHandle.getSchemaTableName());
        icebergTable.updateSchema().deleteColumn(handle.getName()).commit();
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        IcebergColumnHandle columnHandle = (IcebergColumnHandle)source;
        org.apache.iceberg.Table icebergTable = IcebergUtil.getIcebergTable(this.metastore, this.hdfsEnvironment, session, icebergTableHandle.getSchemaTableName());
        icebergTable.updateSchema().renameColumn(columnHandle.getName(), target).commit();
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName table) {
        if (!this.metastore.getTable(new HiveIdentity(session), table.getSchemaName(), table.getTableName()).isPresent()) {
            throw new TableNotFoundException(table);
        }
        org.apache.iceberg.Table icebergTable = IcebergUtil.getIcebergTable(this.metastore, this.hdfsEnvironment, session, table);
        List<ColumnMetadata> columns = this.getColumnMetadatas(icebergTable);
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"format", (Object)IcebergUtil.getFileFormat(icebergTable));
        if (!icebergTable.spec().fields().isEmpty()) {
            properties.put((Object)"partitioning", PartitionFields.toPartitionFields(icebergTable.spec()));
        }
        return new ConnectorTableMetadata(table, columns, (Map)properties.build(), Optional.empty());
    }

    private List<ColumnMetadata> getColumnMetadatas(org.apache.iceberg.Table table) {
        return (List)table.schema().columns().stream().map(column -> ColumnMetadata.builder().setName(column.name()).setType(TypeConverter.toPrestoType(column.type(), this.typeManager)).setComment(Optional.ofNullable(column.doc())).build()).collect(ImmutableList.toImmutableList());
    }

    private static Schema toIcebergSchema(List<ColumnMetadata> columns) {
        ArrayList<Types.NestedField> icebergColumns = new ArrayList<Types.NestedField>();
        for (ColumnMetadata column : columns) {
            if (column.isHidden()) continue;
            int index = icebergColumns.size();
            Type type = TypeConverter.toIcebergType(column.getType());
            Types.NestedField field = column.isNullable() ? Types.NestedField.optional((int)index, (String)column.getName(), (Type)type, (String)column.getComment()) : Types.NestedField.required((int)index, (String)column.getName(), (Type)type, (String)column.getComment());
            icebergColumns.add(field);
        }
        Schema schema = new Schema(icebergColumns);
        AtomicInteger nextFieldId = new AtomicInteger(1);
        return TypeUtil.assignFreshIds((Schema)schema, nextFieldId::getAndIncrement);
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector only supports delete where one or more partitions are deleted entirely");
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        org.apache.iceberg.Table icebergTable = IcebergUtil.getIcebergTable(this.metastore, this.hdfsEnvironment, session, handle.getSchemaTableName());
        icebergTable.newDelete().deleteFromRowFilter(ExpressionConverter.toIcebergExpression(handle.getPredicate(), session)).commit();
        return OptionalLong.empty();
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public HiveMetastore getMetastore() {
        return this.metastore;
    }

    public void rollback() {
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        IcebergTableHandle table = (IcebergTableHandle)handle;
        TupleDomain newDomain = DomainConverter.convertTupleDomainTypes((TupleDomain<IcebergColumnHandle>)constraint.getSummary().transform(IcebergColumnHandle.class::cast).simplify()).intersect(table.getPredicate());
        if (newDomain.equals(table.getPredicate())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)new IcebergTableHandle(table.getSchemaName(), table.getTableName(), table.getTableType(), table.getSnapshotId(), (TupleDomain<IcebergColumnHandle>)newDomain), constraint.getSummary()));
    }
}

