/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import io.airlift.json.JsonCodec;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.prestosql.plugin.iceberg.CommitTaskData;
import io.prestosql.plugin.iceberg.IcebergConfig;
import io.prestosql.plugin.iceberg.IcebergMetadata;
import io.prestosql.spi.type.TypeManager;
import java.util.Objects;
import javax.inject.Inject;

public class IcebergMetadataFactory {
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private final long metastoreTransactionCacheSize;

    @Inject
    public IcebergMetadataFactory(IcebergConfig config, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskDataJsonCodec) {
        this(metastore, hdfsEnvironment, typeManager, commitTaskDataJsonCodec, config.getMetastoreTransactionCacheSize());
    }

    public IcebergMetadataFactory(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskCodec, long metastoreTransactionCacheSize) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        this.metastoreTransactionCacheSize = metastoreTransactionCacheSize;
    }

    public IcebergMetadata create() {
        return new IcebergMetadata((HiveMetastore)CachingHiveMetastore.memoizeMetastore((HiveMetastore)this.metastore, (long)this.metastoreTransactionCacheSize), this.hdfsEnvironment, this.typeManager, this.commitTaskCodec);
    }
}

