/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonCodecBinder;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HiveHdfsModule;
import io.prestosql.plugin.hive.HiveNodePartitioningProvider;
import io.prestosql.plugin.hive.orc.OrcReaderConfig;
import io.prestosql.plugin.hive.orc.OrcWriterConfig;
import io.prestosql.plugin.hive.parquet.ParquetReaderConfig;
import io.prestosql.plugin.hive.parquet.ParquetWriterConfig;
import io.prestosql.plugin.iceberg.CommitTaskData;
import io.prestosql.plugin.iceberg.IcebergConfig;
import io.prestosql.plugin.iceberg.IcebergFileWriterFactory;
import io.prestosql.plugin.iceberg.IcebergMetadataFactory;
import io.prestosql.plugin.iceberg.IcebergPageSinkProvider;
import io.prestosql.plugin.iceberg.IcebergPageSourceProvider;
import io.prestosql.plugin.iceberg.IcebergSessionProperties;
import io.prestosql.plugin.iceberg.IcebergSplitManager;
import io.prestosql.plugin.iceberg.IcebergTableProperties;
import io.prestosql.plugin.iceberg.IcebergTransactionManager;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import org.weakref.jmx.guice.ExportBinder;

public class IcebergModule
implements Module {
    public void configure(Binder binder) {
        binder.install((Module)new HiveHdfsModule());
        binder.bind(IcebergTransactionManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(IcebergConfig.class);
        binder.bind(IcebergSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(IcebergTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(IcebergSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSourceProvider.class).to(IcebergPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(IcebergPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorNodePartitioningProvider.class).to(HiveNodePartitioningProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(OrcReaderConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(OrcWriterConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ParquetReaderConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ParquetWriterConfig.class);
        binder.bind(IcebergMetadataFactory.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(CommitTaskData.class);
        binder.bind(FileFormatDataSourceStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(FileFormatDataSourceStats.class).withGeneratedName();
        binder.bind(IcebergFileWriterFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(IcebergFileWriterFactory.class).withGeneratedName();
    }
}

