/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.plugin.iceberg.IcebergErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.predicate.Utils;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IcebergPageSource
implements ConnectorPageSource {
    private final Block[] prefilledBlocks;
    private final int[] delegateIndexes;
    private final ConnectorPageSource delegate;

    public IcebergPageSource(List<IcebergColumnHandle> columns, Map<Integer, String> partitionKeys, ConnectorPageSource delegate, TimeZoneKey timeZoneKey) {
        int size = Objects.requireNonNull(columns, "columns is null").size();
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.prefilledBlocks = new Block[size];
        this.delegateIndexes = new int[size];
        int outputIndex = 0;
        int delegateIndex = 0;
        for (IcebergColumnHandle column : columns) {
            String partitionValue = partitionKeys.get(column.getId());
            if (partitionValue != null) {
                Type type = column.getType();
                Object prefilledValue = IcebergPageSource.deserializePartitionValue(type, partitionValue, column.getName(), timeZoneKey);
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)type, (Object)prefilledValue);
                this.delegateIndexes[outputIndex] = -1;
            } else {
                this.delegateIndexes[outputIndex] = delegateIndex++;
            }
            ++outputIndex;
        }
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            int batchSize = dataPage.getPositionCount();
            Block[] blocks = new Block[this.prefilledBlocks.length];
            for (int i = 0; i < this.prefilledBlocks.length; ++i) {
                blocks[i] = this.prefilledBlocks[i] != null ? new RunLengthEncodedBlock(this.prefilledBlocks[i], batchSize) : dataPage.getBlock(this.delegateIndexes[i]);
            }
            return new Page(batchSize, blocks);
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            Throwables.throwIfInstanceOf((Throwable)e, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private static Object deserializePartitionValue(Type type, String valueString, String name, TimeZoneKey timeZoneKey) {
        try {
            if (type.equals(BooleanType.BOOLEAN)) {
                if (valueString.equalsIgnoreCase("true")) {
                    return true;
                }
                if (valueString.equalsIgnoreCase("false")) {
                    return false;
                }
                throw new IllegalArgumentException();
            }
            if (type.equals(IntegerType.INTEGER)) {
                return Long.parseLong(valueString);
            }
            if (type.equals(BigintType.BIGINT)) {
                return Long.parseLong(valueString);
            }
            if (type.equals(RealType.REAL)) {
                return (long)Float.floatToRawIntBits(Float.parseFloat(valueString));
            }
            if (type.equals(DoubleType.DOUBLE)) {
                return Double.parseDouble(valueString);
            }
            if (type.equals(DateType.DATE)) {
                return Long.parseLong(valueString);
            }
            if (type.equals(TimeType.TIME)) {
                return Long.parseLong(valueString);
            }
            if (type.equals(TimestampType.TIMESTAMP)) {
                return Long.parseLong(valueString);
            }
            if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
                return DateTimeEncoding.packDateTimeWithZone((long)Long.parseLong(valueString), (TimeZoneKey)timeZoneKey);
            }
            if (Varchars.isVarcharType((Type)type)) {
                Slice value = Slices.utf8Slice((String)valueString);
                VarcharType varcharType = (VarcharType)type;
                if (!varcharType.isUnbounded() && SliceUtf8.countCodePoints((Slice)value) > varcharType.getBoundedLength()) {
                    throw new IllegalArgumentException();
                }
                return value;
            }
            if (type.equals(VarbinaryType.VARBINARY)) {
                return Slices.utf8Slice((String)valueString);
            }
            if (Decimals.isShortDecimal((Type)type) || Decimals.isLongDecimal((Type)type)) {
                DecimalType decimalType = (DecimalType)type;
                BigDecimal decimal = new BigDecimal(valueString);
                if ((decimal = decimal.setScale(decimalType.getScale(), 7)).precision() > decimalType.getPrecision()) {
                    throw new IllegalArgumentException();
                }
                BigInteger unscaledValue = decimal.unscaledValue();
                return Decimals.isShortDecimal((Type)type) ? Long.valueOf(unscaledValue.longValue()) : Decimals.encodeUnscaledValue((BigInteger)unscaledValue);
            }
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", valueString, type.getDisplayName(), name));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid partition type " + type.toString());
    }
}

