/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcColumn;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcPredicate;
import io.prestosql.orc.OrcReader;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.orc.OrcRecordReader;
import io.prestosql.orc.TupleDomainOrcPredicate;
import io.prestosql.parquet.ParquetCorruptionException;
import io.prestosql.parquet.ParquetDataSource;
import io.prestosql.parquet.ParquetReaderOptions;
import io.prestosql.parquet.ParquetTypeUtils;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.predicate.Predicate;
import io.prestosql.parquet.predicate.PredicateUtils;
import io.prestosql.parquet.reader.MetadataReader;
import io.prestosql.parquet.reader.ParquetReader;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.orc.HdfsOrcDataSource;
import io.prestosql.plugin.hive.orc.OrcPageSource;
import io.prestosql.plugin.hive.orc.OrcReaderConfig;
import io.prestosql.plugin.hive.parquet.HdfsParquetDataSource;
import io.prestosql.plugin.hive.parquet.ParquetColumnIOConverter;
import io.prestosql.plugin.hive.parquet.ParquetPageSource;
import io.prestosql.plugin.hive.parquet.ParquetReaderConfig;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.plugin.iceberg.IcebergErrorCode;
import io.prestosql.plugin.iceberg.IcebergPageSource;
import io.prestosql.plugin.iceberg.IcebergSessionProperties;
import io.prestosql.plugin.iceberg.IcebergSplit;
import io.prestosql.plugin.iceberg.IcebergTableHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.iceberg.FileFormat;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;

public class IcebergPageSourceProvider
implements ConnectorPageSourceProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final OrcReaderOptions orcReaderOptions;
    private final ParquetReaderOptions parquetReaderOptions;

    @Inject
    public IcebergPageSourceProvider(HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats fileFormatDataSourceStats, OrcReaderConfig orcReaderConfig, ParquetReaderConfig parquetReaderConfig) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.orcReaderOptions = Objects.requireNonNull(orcReaderConfig, "orcReaderConfig is null").toOrcReaderOptions();
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderConfig, "parquetReaderConfig is null").toParquetReaderOptions();
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableHandle connectorTable, List<ColumnHandle> columns, TupleDomain<ColumnHandle> dynamicFilter) {
        IcebergSplit split = (IcebergSplit)connectorSplit;
        IcebergTableHandle table = (IcebergTableHandle)connectorTable;
        List icebergColumns = (List)columns.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        Map<Integer, String> partitionKeys = split.getPartitionKeys();
        List regularColumns = (List)columns.stream().map(IcebergColumnHandle.class::cast).filter(column -> !partitionKeys.containsKey(column.getId())).collect(ImmutableList.toImmutableList());
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getSchemaName(), table.getTableName());
        ConnectorPageSource dataPageSource = this.createDataPageSource(session, hdfsContext, new Path(split.getPath()), split.getStart(), split.getLength(), split.getFileFormat(), regularColumns, split.getPredicate());
        return new IcebergPageSource(icebergColumns, partitionKeys, dataPageSource, session.getTimeZoneKey());
    }

    private ConnectorPageSource createDataPageSource(ConnectorSession session, HdfsEnvironment.HdfsContext hdfsContext, Path path, long start, long length, FileFormat fileFormat, List<IcebergColumnHandle> dataColumns, TupleDomain<IcebergColumnHandle> predicate) {
        switch (fileFormat) {
            case ORC: {
                FileSystem fileSystem = null;
                FileStatus fileStatus = null;
                try {
                    fileSystem = this.hdfsEnvironment.getFileSystem(hdfsContext, path);
                    fileStatus = fileSystem.getFileStatus(path);
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, (Throwable)e);
                }
                long fileSize = fileStatus.getLen();
                return IcebergPageSourceProvider.createOrcPageSource(this.hdfsEnvironment, session.getUser(), this.hdfsEnvironment.getConfiguration(hdfsContext, path), path, start, length, fileSize, dataColumns, predicate, this.orcReaderOptions.withMaxMergeDistance(IcebergSessionProperties.getOrcMaxMergeDistance(session)).withMaxBufferSize(IcebergSessionProperties.getOrcMaxBufferSize(session)).withStreamBufferSize(IcebergSessionProperties.getOrcStreamBufferSize(session)).withTinyStripeThreshold(IcebergSessionProperties.getOrcTinyStripeThreshold(session)).withMaxReadBlockSize(IcebergSessionProperties.getOrcMaxReadBlockSize(session)).withLazyReadSmallRanges(IcebergSessionProperties.getOrcLazyReadSmallRanges(session)).withNestedLazy(IcebergSessionProperties.isOrcNestedLazy(session)).withBloomFiltersEnabled(IcebergSessionProperties.isOrcBloomFiltersEnabled(session)), this.fileFormatDataSourceStats);
            }
            case PARQUET: {
                return IcebergPageSourceProvider.createParquetPageSource(this.hdfsEnvironment, session.getUser(), this.hdfsEnvironment.getConfiguration(hdfsContext, path), path, start, length, dataColumns, this.parquetReaderOptions.withFailOnCorruptedStatistics(IcebergSessionProperties.isFailOnCorruptedParquetStatistics(session)).withMaxReadBlockSize(IcebergSessionProperties.getParquetMaxReadBlockSize(session)), predicate, this.fileFormatDataSourceStats);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "File format not supported for Iceberg: " + fileFormat);
    }

    private static ConnectorPageSource createOrcPageSource(HdfsEnvironment hdfsEnvironment, String user, Configuration configuration, Path path, long start, long length, long fileSize, List<IcebergColumnHandle> columns, TupleDomain<IcebergColumnHandle> effectivePredicate, OrcReaderOptions options, FileFormatDataSourceStats stats) {
        HdfsOrcDataSource orcDataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FSDataInputStream inputStream = (FSDataInputStream)hdfsEnvironment.doAs(user, () -> fileSystem.open(path));
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSize, options, inputStream, stats);
            OrcReader reader = new OrcReader((OrcDataSource)orcDataSource, options);
            List fileColumns = reader.getRootColumn().getNestedColumns();
            Map fileColumnsByIcebergId = (Map)fileColumns.stream().filter(orcColumn -> orcColumn.getAttributes().containsKey("iceberg.id")).collect(ImmutableMap.toImmutableMap(orcColumn -> Integer.valueOf((String)orcColumn.getAttributes().get("iceberg.id")), Function.identity()));
            ImmutableMap fileColumnsByName = null;
            if (fileColumnsByIcebergId.isEmpty()) {
                fileColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
            }
            TupleDomainOrcPredicate.TupleDomainOrcPredicateBuilder predicateBuilder = TupleDomainOrcPredicate.builder().setBloomFiltersEnabled(options.isBloomFiltersEnabled());
            Map effectivePredicateDomains = (Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Effective predicate is none"));
            ArrayList<OrcColumn> fileReadColumns = new ArrayList<OrcColumn>(columns.size());
            ArrayList<Type> fileReadTypes = new ArrayList<Type>(columns.size());
            ArrayList<OrcPageSource.ColumnAdaptation> columnAdaptations = new ArrayList<OrcPageSource.ColumnAdaptation>(columns.size());
            for (IcebergColumnHandle column : columns) {
                OrcColumn orcColumn2 = fileColumnsByIcebergId.isEmpty() ? (OrcColumn)fileColumnsByName.get(column.getName().toLowerCase(Locale.ENGLISH)) : (OrcColumn)fileColumnsByIcebergId.get(column.getId());
                Type readType = column.getType();
                if (orcColumn2 != null) {
                    int sourceIndex = fileReadColumns.size();
                    columnAdaptations.add(OrcPageSource.ColumnAdaptation.sourceColumn((int)sourceIndex));
                    fileReadColumns.add(orcColumn2);
                    fileReadTypes.add(readType);
                    Domain domain = (Domain)effectivePredicateDomains.get(column);
                    if (domain == null) continue;
                    predicateBuilder.addColumn(orcColumn2.getColumnId(), domain);
                    continue;
                }
                columnAdaptations.add(OrcPageSource.ColumnAdaptation.nullColumn((Type)readType));
            }
            AggregatedMemoryContext systemMemoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            OrcDataSourceId orcDataSourceId = orcDataSource.getId();
            OrcRecordReader recordReader = reader.createRecordReader(fileReadColumns, fileReadTypes, (OrcPredicate)predicateBuilder.build(), start, length, DateTimeZone.UTC, systemMemoryUsage, 1, exception -> IcebergPageSourceProvider.handleException(orcDataSourceId, exception));
            return new OrcPageSource(recordReader, columnAdaptations, (OrcDataSource)orcDataSource, Optional.empty(), systemMemoryUsage, stats);
        }
        catch (Exception e) {
            if (orcDataSource != null) {
                try {
                    orcDataSource.close();
                }
                catch (IOException inputStream) {
                    // empty catch block
                }
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static ConnectorPageSource createParquetPageSource(HdfsEnvironment hdfsEnvironment, String user, Configuration configuration, Path path, long start, long length, List<IcebergColumnHandle> regularColumns, ParquetReaderOptions options, TupleDomain<IcebergColumnHandle> effectivePredicate, FileFormatDataSourceStats fileFormatDataSourceStats) {
        AggregatedMemoryContext systemMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        HdfsParquetDataSource dataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FileStatus fileStatus = fileSystem.getFileStatus(path);
            long fileSize = fileStatus.getLen();
            FSDataInputStream inputStream = (FSDataInputStream)hdfsEnvironment.doAs(user, () -> fileSystem.open(path));
            dataSource = HdfsParquetDataSource.buildHdfsParquetDataSource((FSDataInputStream)inputStream, (Path)path, (long)fileSize, (FileFormatDataSourceStats)fileFormatDataSourceStats, (ParquetReaderOptions)options);
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((FileSystem)fileSystem, (Path)path, (long)fileSize);
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            Map parquetIdToField = (Map)fileSchema.getFields().stream().filter(field -> field.getId() != null).collect(ImmutableMap.toImmutableMap(field -> field.getId().intValue(), Function.identity()));
            List parquetFields = regularColumns.stream().map(column -> {
                if (parquetIdToField.isEmpty()) {
                    return ParquetTypeUtils.getParquetTypeByName((String)column.getName(), (GroupType)fileSchema);
                }
                return (org.apache.parquet.schema.Type)parquetIdToField.get(column.getId());
            }).collect(Collectors.toList());
            MessageType requestedSchema = new MessageType(fileSchema.getName(), (List)parquetFields.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = IcebergPageSourceProvider.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath);
            ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < start || firstDataPage >= start + length || !PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)dataSource, (Map)descriptorsByPath, parquetTupleDomain, (boolean)options.isFailOnCorruptedStatistics())) continue;
                blocks.add(block);
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ParquetReader parquetReader = new ParquetReader(Optional.ofNullable(fileMetaData.getCreatedBy()), messageColumnIO, blocks, (ParquetDataSource)dataSource, systemMemoryContext, options);
            ImmutableList.Builder prestoTypes = ImmutableList.builder();
            ImmutableList.Builder internalFields = ImmutableList.builder();
            for (int columnIndex = 0; columnIndex < regularColumns.size(); ++columnIndex) {
                IcebergColumnHandle column2 = regularColumns.get(columnIndex);
                org.apache.parquet.schema.Type parquetField = (org.apache.parquet.schema.Type)parquetFields.get(columnIndex);
                Type prestoType = column2.getType();
                prestoTypes.add((Object)prestoType);
                if (parquetField == null) {
                    internalFields.add(Optional.empty());
                    continue;
                }
                internalFields.add((Object)ParquetColumnIOConverter.constructField((Type)column2.getType(), (ColumnIO)messageColumnIO.getChild(parquetField.getName())));
            }
            return new ParquetPageSource(parquetReader, (List)prestoTypes.build(), (List)internalFields.build());
        }
        catch (IOException | RuntimeException e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException fileStatus) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof ParquetCorruptionException) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, message, (Throwable)e);
            }
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<IcebergColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().get()).forEach((columnHandle, domain) -> {
            RichColumnDescriptor descriptor;
            String baseType = columnHandle.getType().getTypeSignature().getBase();
            if (!(baseType.equals("map") || baseType.equals("array") || baseType.equals("row") || (descriptor = (RichColumnDescriptor)descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()))) == null)) {
                predicate.put((Object)descriptor, domain);
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.build());
    }

    private static PrestoException handleException(OrcDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof PrestoException) {
            return (PrestoException)exception;
        }
        if (exception instanceof OrcCorruptionException) {
            return new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)exception);
        }
        return new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CURSOR_ERROR, String.format("Failed to read ORC file: %s", dataSourceId), (Throwable)exception);
    }
}

