/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.plugin.base.session.PropertyMetadataUtil;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.orc.OrcReaderConfig;
import io.prestosql.plugin.hive.orc.OrcWriterConfig;
import io.prestosql.plugin.hive.parquet.ParquetReaderConfig;
import io.prestosql.plugin.hive.parquet.ParquetWriterConfig;
import io.prestosql.plugin.iceberg.IcebergConfig;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;

public final class IcebergSessionProperties {
    private static final String COMPRESSION_CODEC = "compression_codec";
    private static final String ORC_BLOOM_FILTERS_ENABLED = "orc_bloom_filters_enabled";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";
    private static final String ORC_MAX_BUFFER_SIZE = "orc_max_buffer_size";
    private static final String ORC_STREAM_BUFFER_SIZE = "orc_stream_buffer_size";
    private static final String ORC_TINY_STRIPE_THRESHOLD = "orc_tiny_stripe_threshold";
    private static final String ORC_MAX_READ_BLOCK_SIZE = "orc_max_read_block_size";
    private static final String ORC_LAZY_READ_SMALL_RANGES = "orc_lazy_read_small_ranges";
    private static final String ORC_NESTED_LAZY_ENABLED = "orc_nested_lazy_enabled";
    private static final String ORC_STRING_STATISTICS_LIMIT = "orc_string_statistics_limit";
    private static final String ORC_WRITER_VALIDATE_PERCENTAGE = "orc_writer_validate_percentage";
    private static final String ORC_WRITER_VALIDATE_MODE = "orc_writer_validate_mode";
    private static final String ORC_WRITER_MIN_STRIPE_SIZE = "orc_writer_min_stripe_size";
    private static final String ORC_WRITER_MAX_STRIPE_SIZE = "orc_writer_max_stripe_size";
    private static final String ORC_WRITER_MAX_STRIPE_ROWS = "orc_writer_max_stripe_rows";
    private static final String ORC_WRITER_MAX_DICTIONARY_MEMORY = "orc_writer_max_dictionary_memory";
    private static final String PARQUET_FAIL_WITH_CORRUPTED_STATISTICS = "parquet_fail_with_corrupted_statistics";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_WRITER_BLOCK_SIZE = "parquet_writer_block_size";
    private static final String PARQUET_WRITER_PAGE_SIZE = "parquet_writer_page_size";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public IcebergSessionProperties(IcebergConfig icebergConfig, OrcReaderConfig orcReaderConfig, OrcWriterConfig orcWriterConfig, ParquetReaderConfig parquetReaderConfig, ParquetWriterConfig parquetWriterConfig) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadata.enumProperty((String)COMPRESSION_CODEC, (String)"Compression codec to use when writing files", HiveCompressionCodec.class, (Enum)icebergConfig.getCompressionCodec(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)ORC_BLOOM_FILTERS_ENABLED, (String)"ORC: Enable bloom filters for predicate pushdown", (Boolean)orcReaderConfig.isBloomFiltersEnabled(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_MAX_MERGE_DISTANCE, (String)"ORC: Maximum size of gap between two reads to merge into a single read", (DataSize)orcReaderConfig.getMaxMergeDistance(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_MAX_BUFFER_SIZE, (String)"ORC: Maximum size of a single read", (DataSize)orcReaderConfig.getMaxBufferSize(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_STREAM_BUFFER_SIZE, (String)"ORC: Size of buffer for streaming reads", (DataSize)orcReaderConfig.getStreamBufferSize(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_TINY_STRIPE_THRESHOLD, (String)"ORC: Threshold below which an ORC stripe or file will read in its entirety", (DataSize)orcReaderConfig.getTinyStripeThreshold(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_MAX_READ_BLOCK_SIZE, (String)"ORC: Soft max size of Presto blocks produced by ORC reader", (DataSize)orcReaderConfig.getMaxBlockSize(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)ORC_LAZY_READ_SMALL_RANGES, (String)"Experimental: ORC: Read small file segments lazily", (Boolean)orcReaderConfig.isLazyReadSmallRanges(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)ORC_NESTED_LAZY_ENABLED, (String)"Experimental: ORC: Lazily read nested data", (Boolean)orcReaderConfig.isNestedLazy(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_STRING_STATISTICS_LIMIT, (String)"ORC: Maximum size of string statistics; drop if exceeding", (DataSize)orcWriterConfig.getStringStatisticsLimit(), (boolean)false)).add((Object)new PropertyMetadata(ORC_WRITER_VALIDATE_PERCENTAGE, "ORC: Percentage of written files to validate by re-reading them", (Type)DoubleType.DOUBLE, Double.class, (Object)orcWriterConfig.getValidationPercentage(), false, value -> {
            double doubleValue = ((Number)value).doubleValue();
            if (doubleValue < 0.0 || doubleValue > 100.0) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 0.0 and 100.0 inclusive: %s", ORC_WRITER_VALIDATE_PERCENTAGE, doubleValue));
            }
            return doubleValue;
        }, value -> value)).add((Object)PropertyMetadata.enumProperty((String)ORC_WRITER_VALIDATE_MODE, (String)"ORC: Level of detail in ORC validation", OrcWriteValidation.OrcWriteValidationMode.class, (Enum)orcWriterConfig.getValidationMode(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_WRITER_MIN_STRIPE_SIZE, (String)"ORC: Min stripe size", (DataSize)orcWriterConfig.getStripeMinSize(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_WRITER_MAX_STRIPE_SIZE, (String)"ORC: Max stripe size", (DataSize)orcWriterConfig.getStripeMaxSize(), (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)ORC_WRITER_MAX_STRIPE_ROWS, (String)"ORC: Max stripe row count", (Integer)orcWriterConfig.getStripeMaxRowCount(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)ORC_WRITER_MAX_DICTIONARY_MEMORY, (String)"ORC: Max dictionary memory", (DataSize)orcWriterConfig.getDictionaryMaxMemory(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)PARQUET_FAIL_WITH_CORRUPTED_STATISTICS, (String)"Parquet: Fail when scanning Parquet files with corrupted statistics", (Boolean)parquetReaderConfig.isFailOnCorruptedStatistics(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_MAX_READ_BLOCK_SIZE, (String)"Parquet: Maximum size of a block to read", (DataSize)parquetReaderConfig.getMaxReadBlockSize(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_WRITER_BLOCK_SIZE, (String)"Parquet: Writer block size", (DataSize)parquetWriterConfig.getBlockSize(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)PARQUET_WRITER_PAGE_SIZE, (String)"Parquet: Writer page size", (DataSize)parquetWriterConfig.getPageSize(), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isOrcBloomFiltersEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_BLOOM_FILTERS_ENABLED, Boolean.class);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getOrcMaxBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcTinyStripeThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_TINY_STRIPE_THRESHOLD, DataSize.class);
    }

    public static DataSize getOrcMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean getOrcLazyReadSmallRanges(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_LAZY_READ_SMALL_RANGES, Boolean.class);
    }

    public static boolean isOrcNestedLazy(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_NESTED_LAZY_ENABLED, Boolean.class);
    }

    public static DataSize getOrcStringStatisticsLimit(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STRING_STATISTICS_LIMIT, DataSize.class);
    }

    public static boolean isOrcWriterValidate(ConnectorSession session) {
        double percentage = (Double)session.getProperty(ORC_WRITER_VALIDATE_PERCENTAGE, Double.class);
        if (percentage == 0.0) {
            return false;
        }
        Preconditions.checkArgument((percentage > 0.0 && percentage <= 100.0 ? 1 : 0) != 0);
        return ThreadLocalRandom.current().nextDouble(100.0) < percentage;
    }

    public static OrcWriteValidation.OrcWriteValidationMode getOrcWriterValidateMode(ConnectorSession session) {
        return (OrcWriteValidation.OrcWriteValidationMode)session.getProperty(ORC_WRITER_VALIDATE_MODE, OrcWriteValidation.OrcWriteValidationMode.class);
    }

    public static DataSize getOrcWriterMinStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_WRITER_MIN_STRIPE_SIZE, DataSize.class);
    }

    public static DataSize getOrcWriterMaxStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_WRITER_MAX_STRIPE_SIZE, DataSize.class);
    }

    public static int getOrcWriterMaxStripeRows(ConnectorSession session) {
        return (Integer)session.getProperty(ORC_WRITER_MAX_STRIPE_ROWS, Integer.class);
    }

    public static DataSize getOrcWriterMaxDictionaryMemory(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_WRITER_MAX_DICTIONARY_MEMORY, DataSize.class);
    }

    public static HiveCompressionCodec getCompressionCodec(ConnectorSession session) {
        return (HiveCompressionCodec)session.getProperty(COMPRESSION_CODEC, HiveCompressionCodec.class);
    }

    public static boolean isFailOnCorruptedParquetStatistics(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_FAIL_WITH_CORRUPTED_STATISTICS, Boolean.class);
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }
}

