/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.FileFormat;

public class IcebergSplit
implements ConnectorSplit {
    private final String path;
    private final long start;
    private final long length;
    private final FileFormat fileFormat;
    private final List<HostAddress> addresses;
    private final TupleDomain<IcebergColumnHandle> predicate;
    private final Map<Integer, String> partitionKeys;

    @JsonCreator
    public IcebergSplit(@JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileFormat") FileFormat fileFormat, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="predicate") TupleDomain<IcebergColumnHandle> predicate, @JsonProperty(value="partitionKeys") Map<Integer, String> partitionKeys) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.start = start;
        this.length = length;
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.partitionKeys = ImmutableMap.copyOf(Objects.requireNonNull(partitionKeys, "partitionKeys is null"));
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getPredicate() {
        return this.predicate;
    }

    @JsonProperty
    public Map<Integer, String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).addValue(this.start).addValue(this.length).toString();
    }
}

