/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import io.prestosql.plugin.base.classloader.ClassLoaderSafeConnectorSplitSource;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.iceberg.IcebergSplitSource;
import io.prestosql.plugin.iceberg.IcebergTableHandle;
import io.prestosql.plugin.iceberg.IcebergTransactionManager;
import io.prestosql.plugin.iceberg.IcebergUtil;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.TypeManager;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;

public class IcebergSplitManager
implements ConnectorSplitManager {
    private final IcebergTransactionManager transactionManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;

    @Inject
    public IcebergSplitManager(IcebergTransactionManager transactionManager, HdfsEnvironment hdfsEnvironment, TypeManager typeManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle handle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        IcebergTableHandle table = (IcebergTableHandle)handle;
        HiveMetastore metastore = this.transactionManager.get(transaction).getMetastore();
        Table icebergTable = IcebergUtil.getIcebergTable(metastore, this.hdfsEnvironment, session, table.getSchemaTableName());
        TableScan tableScan = IcebergUtil.getTableScan(session, table.getPredicate(), table.getSnapshotId(), icebergTable);
        IcebergSplitSource splitSource = new IcebergSplitSource((CloseableIterable<CombinedScanTask>)tableScan.planTasks(), table.getPredicate());
        return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)splitSource, Thread.currentThread().getContextClassLoader());
    }
}

