/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.plugin.iceberg.TableType;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IcebergTableHandle
implements ConnectorTableHandle {
    private static final Pattern TABLE_PATTERN = Pattern.compile("(?<table>[^$@]+)(?:@(?<ver1>[0-9]+))?(?:\\$(?<type>[^@]+)(?:@(?<ver2>[0-9]+))?)?");
    private final String schemaName;
    private final String tableName;
    private final TableType tableType;
    private final Optional<Long> snapshotId;
    private final TupleDomain<IcebergColumnHandle> predicate;

    @JsonCreator
    public IcebergTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tableType") TableType tableType, @JsonProperty(value="snapshotId") Optional<Long> snapshotId, @JsonProperty(value="predicate") TupleDomain<IcebergColumnHandle> predicate) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty
    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getPredicate() {
        return this.predicate;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public SchemaTableName getSchemaTableNameWithType() {
        return new SchemaTableName(this.schemaName, this.tableName + "$" + this.tableType.name());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergTableHandle that = (IcebergTableHandle)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && this.tableType == that.tableType && Objects.equals(this.snapshotId, that.snapshotId) && Objects.equals(this.predicate, that.predicate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaName, this.tableName, this.tableType, this.snapshotId, this.predicate});
    }

    public String toString() {
        return this.getSchemaTableName().toString();
    }

    public static IcebergTableHandle from(SchemaTableName name) {
        Matcher match = TABLE_PATTERN.matcher(name.getTableName());
        if (!match.matches()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Iceberg table name: " + name);
        }
        String table = match.group("table");
        String typeString = match.group("type");
        String ver1 = match.group("ver1");
        String ver2 = match.group("ver2");
        TableType type = TableType.DATA;
        if (typeString != null) {
            try {
                type = TableType.valueOf(typeString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Invalid Iceberg table name (unknown type '%s'): %s", typeString, name));
            }
        }
        Optional<Long> version = Optional.empty();
        if (type == TableType.DATA || type == TableType.PARTITIONS || type == TableType.MANIFESTS || type == TableType.FILES) {
            if (ver1 != null && ver2 != null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Iceberg table name (cannot specify two @ versions): " + name);
            }
            if (ver1 != null) {
                version = Optional.of(Long.parseLong(ver1));
            } else if (ver2 != null) {
                version = Optional.of(Long.parseLong(ver2));
            }
        } else if (ver1 != null || ver2 != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Invalid Iceberg table name (cannot use @ version with table type '%s'): %s", new Object[]{type, name}));
        }
        return new IcebergTableHandle(name.getSchemaName(), table, type, version, (TupleDomain<IcebergColumnHandle>)TupleDomain.all());
    }
}

