/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.iceberg.ExpressionConverter;
import io.prestosql.plugin.iceberg.HiveTableOperations;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.plugin.iceberg.TypeConverter;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.TypeManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;

final class IcebergUtil {
    private IcebergUtil() {
    }

    public static boolean isIcebergTable(io.prestosql.plugin.hive.metastore.Table table) {
        return "iceberg".equalsIgnoreCase((String)table.getParameters().get("table_type"));
    }

    public static Table getIcebergTable(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, ConnectorSession session, SchemaTableName table) {
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getSchemaName(), table.getTableName());
        HiveIdentity identity = new HiveIdentity(session);
        HiveTableOperations operations = new HiveTableOperations(metastore, hdfsEnvironment, hdfsContext, identity, table.getSchemaName(), table.getTableName());
        return new BaseTable((TableOperations)operations, table.getSchemaName() + "." + table.getTableName());
    }

    public static List<IcebergColumnHandle> getColumns(Schema schema, TypeManager typeManager) {
        return (List)schema.columns().stream().map(column -> new IcebergColumnHandle(column.fieldId(), column.name(), TypeConverter.toPrestoType(column.type(), typeManager), Optional.ofNullable(column.doc()))).collect(ImmutableList.toImmutableList());
    }

    public static Map<PartitionField, Integer> getIdentityPartitions(PartitionSpec partitionSpec) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (int i = 0; i < partitionSpec.fields().size(); ++i) {
            PartitionField field = (PartitionField)partitionSpec.fields().get(i);
            if (!field.transform().toString().equals("identity")) continue;
            columns.put((Object)field, (Object)i);
        }
        return columns.build();
    }

    public static String getDataPath(String location) {
        if (!location.endsWith("/")) {
            location = location + "/";
        }
        return location + "data";
    }

    public static FileFormat getFileFormat(Table table) {
        return FileFormat.valueOf((String)table.properties().getOrDefault("write.format.default", "parquet").toUpperCase(Locale.ENGLISH));
    }

    public static TableScan getTableScan(ConnectorSession session, TupleDomain<IcebergColumnHandle> predicates, Optional<Long> snapshotId, Table icebergTable) {
        Expression expression = ExpressionConverter.toIcebergExpression(predicates, session);
        TableScan tableScan = icebergTable.newScan().filter(expression);
        return snapshotId.map(id -> IcebergUtil.isSnapshot(icebergTable, id) ? tableScan.useSnapshot(id.longValue()) : tableScan.asOfTime(id.longValue())).orElse(tableScan);
    }

    private static boolean isSnapshot(Table icebergTable, Long id) {
        return Streams.stream((Iterable)icebergTable.snapshots()).anyMatch(snapshot -> snapshot.snapshotId() == id.longValue());
    }
}

