/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.iceberg.IcebergColumnHandle;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.FileFormat;

public class IcebergWritableTableHandle
implements ConnectorInsertTableHandle,
ConnectorOutputTableHandle {
    private final String schemaName;
    private final String tableName;
    private final String schemaAsJson;
    private final String partitionSpecAsJson;
    private final List<IcebergColumnHandle> inputColumns;
    private final String outputPath;
    private final FileFormat fileFormat;

    @JsonCreator
    public IcebergWritableTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="schemaAsJson") String schemaAsJson, @JsonProperty(value="partitionSpecAsJson") String partitionSpecAsJson, @JsonProperty(value="inputColumns") List<IcebergColumnHandle> inputColumns, @JsonProperty(value="outputPath") String outputPath, @JsonProperty(value="fileFormat") FileFormat fileFormat) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.schemaAsJson = Objects.requireNonNull(schemaAsJson, "schemaAsJson is null");
        this.partitionSpecAsJson = Objects.requireNonNull(partitionSpecAsJson, "partitionSpecAsJson is null");
        this.inputColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputColumns, "inputColumns is null"));
        this.outputPath = Objects.requireNonNull(outputPath, "filePrefix is null");
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getSchemaAsJson() {
        return this.schemaAsJson;
    }

    @JsonProperty
    public String getPartitionSpecAsJson() {
        return this.partitionSpecAsJson;
    }

    @JsonProperty
    public List<IcebergColumnHandle> getInputColumns() {
        return this.inputColumns;
    }

    @JsonProperty
    public String getOutputPath() {
        return this.outputPath;
    }

    @JsonProperty
    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public String toString() {
        return this.schemaName + "." + this.tableName;
    }
}

