/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.event.client.EventModule;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.prestosql.plugin.base.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.prestosql.plugin.base.jmx.MBeanServerModule;
import io.prestosql.plugin.base.security.AllowAllAccessControl;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.authentication.HiveAuthenticationModule;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HiveMetastoreModule;
import io.prestosql.plugin.hive.s3.HiveS3Module;
import io.prestosql.plugin.iceberg.IcebergConnector;
import io.prestosql.plugin.iceberg.IcebergMetadataFactory;
import io.prestosql.plugin.iceberg.IcebergModule;
import io.prestosql.plugin.iceberg.IcebergSchemaProperties;
import io.prestosql.plugin.iceberg.IcebergSessionProperties;
import io.prestosql.plugin.iceberg.IcebergTableProperties;
import io.prestosql.plugin.iceberg.IcebergTransactionManager;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.type.TypeManager;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public final class InternalIcebergConnectorFactory {
    private InternalIcebergConnectorFactory() {
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Optional<HiveMetastore> metastore) {
        ClassLoader classLoader = InternalIcebergConnectorFactory.class.getClassLoader();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new EventModule(), new MBeanModule(), new JsonModule(), new IcebergModule(), new HiveS3Module(), new HiveAuthenticationModule(), new HiveMetastoreModule(metastore), new MBeanServerModule(), binder -> {
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            IcebergTransactionManager transactionManager = (IcebergTransactionManager)injector.getInstance(IcebergTransactionManager.class);
            IcebergMetadataFactory metadataFactory = (IcebergMetadataFactory)injector.getInstance(IcebergMetadataFactory.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            IcebergSessionProperties icebergSessionProperties = (IcebergSessionProperties)injector.getInstance(IcebergSessionProperties.class);
            IcebergTableProperties icebergTableProperties = (IcebergTableProperties)injector.getInstance(IcebergTableProperties.class);
            IcebergConnector icebergConnector = new IcebergConnector(lifeCycleManager, transactionManager, metadataFactory, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, classLoader), (Set<SystemTable>)ImmutableSet.of(), icebergSessionProperties.getSessionProperties(), IcebergSchemaProperties.SCHEMA_PROPERTIES, icebergTableProperties.getTableProperties(), (ConnectorAccessControl)new AllowAllAccessControl());
            return icebergConnector;
        }
    }
}

