/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.iceberg.IcebergErrorCode;
import io.prestosql.plugin.iceberg.util.PageListBuilder;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class ManifestsTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;

    public ManifestsTable(SchemaTableName tableName, Table icebergTable, Optional<Long> snapshotId) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(tableName, (List)ImmutableList.builder().add((Object)new ColumnMetadata("path", (io.prestosql.spi.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("length", (io.prestosql.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("partition_spec_id", (io.prestosql.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("added_snapshot_id", (io.prestosql.spi.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("added_data_files_count", (io.prestosql.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("existing_data_files_count", (io.prestosql.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("deleted_data_files_count", (io.prestosql.spi.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("partitions", (io.prestosql.spi.type.Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"contains_null", (io.prestosql.spi.type.Type)BooleanType.BOOLEAN), RowType.field((String)"lower_bound", (io.prestosql.spi.type.Type)VarcharType.VARCHAR), RowType.field((String)"upper_bound", (io.prestosql.spi.type.Type)VarcharType.VARCHAR)}))).build());
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(ManifestsTable.buildPages(this.tableMetadata, this.icebergTable, this.snapshotId));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, Table icebergTable, Optional<Long> snapshotId) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        Snapshot snapshot = snapshotId.map(arg_0 -> ((Table)icebergTable).snapshot(arg_0)).orElseGet(() -> ((Table)icebergTable).currentSnapshot());
        if (snapshot == null) {
            if (snapshotId.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_SNAPSHOT_ID, "Invalid snapshot ID: " + snapshotId.get());
            }
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, "There's no snapshot associated with table " + tableMetadata.getTable().toString());
        }
        Map partitionSpecsById = icebergTable.specs();
        snapshot.manifests().forEach(file -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendVarchar(file.path());
            pagesBuilder.appendBigint(file.length());
            pagesBuilder.appendInteger(file.partitionSpecId());
            pagesBuilder.appendBigint(file.snapshotId());
            pagesBuilder.appendInteger(file.addedFilesCount());
            pagesBuilder.appendInteger(file.existingFilesCount());
            pagesBuilder.appendInteger(file.deletedFilesCount());
            ManifestsTable.writePartitionSummaries(pagesBuilder.nextColumn(), file.partitions(), (PartitionSpec)partitionSpecsById.get(file.partitionSpecId()));
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }

    private static void writePartitionSummaries(BlockBuilder blockBuilder, List<ManifestFile.PartitionFieldSummary> summaries, PartitionSpec partitionSpec) {
        for (int i = 0; i < summaries.size(); ++i) {
            ManifestFile.PartitionFieldSummary summary = summaries.get(i);
            PartitionField field = (PartitionField)partitionSpec.fields().get(i);
            Type nestedType = ((Types.NestedField)partitionSpec.partitionType().fields().get(i)).type();
            BlockBuilder rowBuilder = blockBuilder.beginBlockEntry();
            BooleanType.BOOLEAN.writeBoolean(rowBuilder, summary.containsNull());
            VarcharType.VARCHAR.writeString(rowBuilder, field.transform().toHumanString(Conversions.fromByteBuffer((Type)nestedType, (ByteBuffer)summary.lowerBound())));
            VarcharType.VARCHAR.writeString(rowBuilder, field.transform().toHumanString(Conversions.fromByteBuffer((Type)nestedType, (ByteBuffer)summary.upperBound())));
            blockBuilder.closeEntry();
        }
    }
}

