/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Map;

public final class PageListBuilder {
    private final int channels;
    private final PageBuilder pageBuilder;
    private ImmutableList.Builder<Page> pages;
    private int channel;

    public PageListBuilder(List<Type> types) {
        this.channels = types.size();
        this.pageBuilder = new PageBuilder(types);
        this.reset();
    }

    public void reset() {
        this.pages = ImmutableList.builder();
        this.pageBuilder.reset();
        this.channel = -1;
    }

    public List<Page> build() {
        Preconditions.checkArgument((this.channel == -1 ? 1 : 0) != 0, (Object)"cannot be in row");
        if (!this.pageBuilder.isEmpty()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        return this.pages.build();
    }

    public void beginRow() {
        Preconditions.checkArgument((this.channel == -1 ? 1 : 0) != 0, (Object)"already in row");
        if (this.pageBuilder.isFull()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        this.pageBuilder.declarePosition();
        this.channel = 0;
    }

    public void endRow() {
        Preconditions.checkArgument((this.channel == this.channels ? 1 : 0) != 0, (Object)"not at end of row");
        this.channel = -1;
    }

    public void appendNull() {
        this.nextColumn().appendNull();
    }

    public void appendInteger(int value) {
        IntegerType.INTEGER.writeLong(this.nextColumn(), (long)value);
    }

    public void appendBigint(long value) {
        BigintType.BIGINT.writeLong(this.nextColumn(), value);
    }

    public void appendTimestamp(long value) {
        TimestampType.TIMESTAMP.writeLong(this.nextColumn(), value);
    }

    public void appendVarchar(String value) {
        VarcharType.VARCHAR.writeString(this.nextColumn(), value);
    }

    public void appendVarbinary(Slice value) {
        VarbinaryType.VARBINARY.writeSlice(this.nextColumn(), value);
    }

    public void appendBigintArray(Iterable<Long> values) {
        BlockBuilder column = this.nextColumn();
        BlockBuilder array = column.beginBlockEntry();
        for (Long value : values) {
            BigintType.BIGINT.writeLong(array, value.longValue());
        }
        column.closeEntry();
    }

    public void appendVarcharArray(Iterable<String> values) {
        BlockBuilder column = this.nextColumn();
        BlockBuilder array = column.beginBlockEntry();
        for (String value : values) {
            VarcharType.VARCHAR.writeString(array, value);
        }
        column.closeEntry();
    }

    public void appendVarcharVarcharMap(Map<String, String> values) {
        BlockBuilder column = this.nextColumn();
        BlockBuilder map = column.beginBlockEntry();
        values.forEach((key, value) -> {
            VarcharType.VARCHAR.writeString(map, key);
            VarcharType.VARCHAR.writeString(map, value);
        });
        column.closeEntry();
    }

    public void appendIntegerBigintMap(Map<Integer, Long> values) {
        BlockBuilder column = this.nextColumn();
        BlockBuilder map = column.beginBlockEntry();
        values.forEach((key, value) -> {
            IntegerType.INTEGER.writeLong(map, (long)key.intValue());
            BigintType.BIGINT.writeLong(map, value.longValue());
        });
        column.closeEntry();
    }

    public void appendIntegerVarcharMap(Map<Integer, String> values) {
        BlockBuilder column = this.nextColumn();
        BlockBuilder map = column.beginBlockEntry();
        values.forEach((key, value) -> {
            IntegerType.INTEGER.writeLong(map, (long)key.intValue());
            VarcharType.VARCHAR.writeString(map, value);
        });
        column.closeEntry();
    }

    public BlockBuilder nextColumn() {
        int currentChannel = this.channel++;
        return this.pageBuilder.getBlockBuilder(currentChannel);
    }

    public static PageListBuilder forTable(ConnectorTableMetadata table) {
        return new PageListBuilder((List)table.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList()));
    }
}

