/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile;

import io.airlift.compress.gzip.JdkGzipCodec;
import io.airlift.compress.lz4.Lz4Codec;
import io.airlift.compress.lzo.LzoCodec;
import io.airlift.compress.snappy.SnappyCodec;
import io.prestosql.rcfile.AircompressorCompressor;
import io.prestosql.rcfile.AircompressorDecompressor;
import io.prestosql.rcfile.RcFileCodecFactory;
import io.prestosql.rcfile.RcFileCompressor;
import io.prestosql.rcfile.RcFileDecompressor;
import java.util.Objects;
import org.apache.hadoop.io.compress.CompressionCodec;

public class AircompressorCodecFactory
implements RcFileCodecFactory {
    private static final String SNAPPY_CODEC_NAME = "org.apache.hadoop.io.compress.SnappyCodec";
    private static final String LZO_CODEC_NAME = "com.hadoop.compression.lzo.LzoCodec";
    private static final String LZO_CODEC_NAME_DEPRECATED = "org.apache.hadoop.io.compress.LzoCodec";
    private static final String LZ4_CODEC_NAME = "org.apache.hadoop.io.compress.Lz4Codec";
    private static final String LZ4_HC_CODEC_NAME = "org.apache.hadoop.io.compress.Lz4Codec";
    private static final String GZIP_CODEC_NAME = "org.apache.hadoop.io.compress.GzipCodec";
    private final RcFileCodecFactory delegate;

    public AircompressorCodecFactory(RcFileCodecFactory delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public RcFileCompressor createCompressor(String codecName) {
        if (SNAPPY_CODEC_NAME.equals(codecName)) {
            return new AircompressorCompressor((CompressionCodec)new SnappyCodec());
        }
        if (LZO_CODEC_NAME.equals(codecName) || LZO_CODEC_NAME_DEPRECATED.equals(codecName)) {
            return new AircompressorCompressor((CompressionCodec)new LzoCodec());
        }
        if ("org.apache.hadoop.io.compress.Lz4Codec".equals(codecName)) {
            return new AircompressorCompressor((CompressionCodec)new Lz4Codec());
        }
        if (GZIP_CODEC_NAME.equals(codecName)) {
            return new AircompressorCompressor((CompressionCodec)new JdkGzipCodec());
        }
        return this.delegate.createCompressor(codecName);
    }

    @Override
    public RcFileDecompressor createDecompressor(String codecName) {
        if (SNAPPY_CODEC_NAME.equals(codecName)) {
            return new AircompressorDecompressor((CompressionCodec)new SnappyCodec());
        }
        if (LZO_CODEC_NAME.equals(codecName) || LZO_CODEC_NAME_DEPRECATED.equals(codecName)) {
            return new AircompressorDecompressor((CompressionCodec)new LzoCodec());
        }
        if ("org.apache.hadoop.io.compress.Lz4Codec".equals(codecName) || "org.apache.hadoop.io.compress.Lz4Codec".equals(codecName)) {
            return new AircompressorDecompressor((CompressionCodec)new Lz4Codec());
        }
        if (GZIP_CODEC_NAME.equals(codecName)) {
            return new AircompressorDecompressor((CompressionCodec)new JdkGzipCodec());
        }
        return this.delegate.createDecompressor(codecName);
    }
}

