/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile;

import io.prestosql.rcfile.RcFileDataSource;
import io.prestosql.rcfile.RcFileDataSourceId;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;

public class FileRcFileDataSource
implements RcFileDataSource {
    private final File path;
    private final long size;
    private final RandomAccessFile input;
    private long readTimeNanos;
    private long readBytes;

    public FileRcFileDataSource(File path) throws IOException {
        this.path = Objects.requireNonNull(path, "path is null");
        this.size = path.length();
        this.input = new RandomAccessFile(path, "r");
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long start = System.nanoTime();
        this.input.seek(position);
        this.input.readFully(buffer, bufferOffset, bufferLength);
        this.readTimeNanos += System.nanoTime() - start;
        this.readBytes += (long)bufferLength;
    }

    @Override
    public RcFileDataSourceId getId() {
        return new RcFileDataSourceId(this.path.getPath());
    }

    public String toString() {
        return this.path.getPath();
    }
}

