/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.rcfile.ColumnData;
import io.prestosql.rcfile.EncodeOutput;
import io.prestosql.rcfile.RcFileCorruptionException;
import io.prestosql.rcfile.text.TextColumnEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;

public abstract class BlockEncoding
implements TextColumnEncoding {
    private final Type type;
    protected final Slice nullSequence;
    private final byte[] separators;
    private final Byte escapeByte;

    public BlockEncoding(Type type, Slice nullSequence, byte[] separators, Byte escapeByte) {
        this.type = type;
        this.nullSequence = nullSequence;
        this.separators = separators;
        this.escapeByte = escapeByte;
    }

    @Override
    public final void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) throws RcFileCorruptionException {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                this.encodeValueInto(1, block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public final Block decodeColumn(ColumnData columnData) throws RcFileCorruptionException {
        int size = columnData.rowCount();
        Slice slice = columnData.getSlice();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            int offset = columnData.getOffset(i);
            if (!this.isNullSequence(slice, offset, length)) {
                this.decodeValueInto(1, builder, slice, offset, length);
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    protected final boolean isNullSequence(Slice slice, int offset, int length) {
        return this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length);
    }

    protected final boolean isEscapeByte(byte currentByte) {
        return this.escapeByte != null && currentByte == this.escapeByte;
    }

    protected final byte getSeparator(int depth) {
        return this.separators[depth];
    }
}

