/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import org.apache.iceberg.parquet.PageIterator;
import org.apache.iceberg.parquet.TripleIterator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;

public abstract class ColumnIterator<T>
implements TripleIterator<T> {
    private final ColumnDescriptor desc;
    private final PageIterator<T> pageIterator;
    private PageReader pageSource = null;
    private long triplesCount = 0L;
    private long triplesRead = 0L;
    private long advanceNextPageCount = 0L;

    static <T> ColumnIterator<T> newIterator(ColumnDescriptor desc, String writerVersion) {
        switch (desc.getPrimitiveType().getPrimitiveTypeName()) {
            case BOOLEAN: {
                return new ColumnIterator<Boolean>(desc, writerVersion){

                    @Override
                    public Boolean next() {
                        return this.nextBoolean();
                    }
                };
            }
            case INT32: {
                return new ColumnIterator<Integer>(desc, writerVersion){

                    @Override
                    public Integer next() {
                        return this.nextInteger();
                    }
                };
            }
            case INT64: {
                return new ColumnIterator<Long>(desc, writerVersion){

                    @Override
                    public Long next() {
                        return this.nextLong();
                    }
                };
            }
            case FLOAT: {
                return new ColumnIterator<Float>(desc, writerVersion){

                    @Override
                    public Float next() {
                        return Float.valueOf(this.nextFloat());
                    }
                };
            }
            case DOUBLE: {
                return new ColumnIterator<Double>(desc, writerVersion){

                    @Override
                    public Double next() {
                        return this.nextDouble();
                    }
                };
            }
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                return new ColumnIterator<Binary>(desc, writerVersion){

                    @Override
                    public Binary next() {
                        return this.nextBinary();
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + desc.getPrimitiveType().getPrimitiveTypeName());
    }

    private ColumnIterator(ColumnDescriptor desc, String writerVersion) {
        this.desc = desc;
        this.pageIterator = PageIterator.newIterator(desc, writerVersion);
    }

    public void setPageSource(PageReader source) {
        this.pageSource = source;
        this.triplesCount = source.getTotalValueCount();
        this.triplesRead = 0L;
        this.advanceNextPageCount = 0L;
        this.pageIterator.reset();
        this.pageIterator.setDictionary(ColumnIterator.readDictionary(this.desc, this.pageSource));
        this.advance();
    }

    private void advance() {
        if (this.triplesRead >= this.advanceNextPageCount) {
            while (!this.pageIterator.hasNext()) {
                DataPage page = this.pageSource.readPage();
                if (page != null) {
                    this.pageIterator.setPage(page);
                    this.advanceNextPageCount += (long)this.pageIterator.currentPageCount();
                    continue;
                }
                return;
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.triplesRead < this.triplesCount;
    }

    @Override
    public int currentDefinitionLevel() {
        this.advance();
        return this.pageIterator.currentDefinitionLevel();
    }

    @Override
    public int currentRepetitionLevel() {
        this.advance();
        return this.pageIterator.currentRepetitionLevel();
    }

    @Override
    public boolean nextBoolean() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextBoolean();
    }

    @Override
    public int nextInteger() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextInteger();
    }

    @Override
    public long nextLong() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextLong();
    }

    @Override
    public float nextFloat() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextFloat();
    }

    @Override
    public double nextDouble() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextDouble();
    }

    @Override
    public Binary nextBinary() {
        ++this.triplesRead;
        this.advance();
        return this.pageIterator.nextBinary();
    }

    @Override
    public <N> N nextNull() {
        ++this.triplesRead;
        this.advance();
        return (N)this.pageIterator.nextNull();
    }

    private static Dictionary readDictionary(ColumnDescriptor desc, PageReader pageSource) {
        DictionaryPage dictionaryPage = pageSource.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                return dictionaryPage.getEncoding().initDictionary(desc, dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not decode the dictionary for " + desc, (Throwable)e);
            }
        }
        return null;
    }
}

