/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.parquet.ParquetConversions;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetMetricsRowGroupFilter {
    private final Schema schema;
    private final Types.StructType struct;
    private final Expression expr;
    private transient ThreadLocal<MetricsEvalVisitor> visitors = null;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    private MetricsEvalVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new MetricsEvalVisitor());
        }
        return this.visitors.get();
    }

    public ParquetMetricsRowGroupFilter(Schema schema, Expression unbound) {
        this(schema, unbound, true);
    }

    public ParquetMetricsRowGroupFilter(Schema schema, Expression unbound, boolean caseSensitive) {
        this.schema = schema;
        this.struct = schema.asStruct();
        this.expr = Binder.bind((Types.StructType)this.struct, (Expression)Expressions.rewriteNot((Expression)unbound), (boolean)caseSensitive);
    }

    public boolean shouldRead(MessageType fileSchema, BlockMetaData rowGroup) {
        return this.visitor().eval(fileSchema, rowGroup);
    }

    private class MetricsEvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private Map<Integer, Statistics> stats = null;
        private Map<Integer, Long> valueCounts = null;
        private Map<Integer, Function<Object, Object>> conversions = null;

        private MetricsEvalVisitor() {
        }

        private boolean eval(MessageType fileSchema, BlockMetaData rowGroup) {
            if (rowGroup.getRowCount() <= 0L) {
                return false;
            }
            this.stats = Maps.newHashMap();
            this.valueCounts = Maps.newHashMap();
            this.conversions = Maps.newHashMap();
            for (ColumnChunkMetaData col : rowGroup.getColumns()) {
                PrimitiveType colType = fileSchema.getType(col.getPath().toArray()).asPrimitiveType();
                if (colType.getId() == null) continue;
                int id = colType.getId().intValue();
                this.stats.put(id, col.getStatistics());
                this.valueCounts.put(id, col.getValueCount());
                this.conversions.put(id, ParquetConversions.converterFromParquet(colType));
            }
            return ExpressionVisitors.visitEvaluator((Expression)ParquetMetricsRowGroupFilter.this.expr, (ExpressionVisitors.ExpressionVisitor)this);
        }

        public Boolean alwaysTrue() {
            return true;
        }

        public Boolean alwaysFalse() {
            return false;
        }

        public Boolean not(Boolean result) {
            return result == false;
        }

        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        public <T> Boolean isNull(BoundReference<T> ref) {
            Integer id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return true;
            }
            Statistics colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty() && colStats.getNumNulls() == 0L) {
                return false;
            }
            return true;
        }

        public <T> Boolean notNull(BoundReference<T> ref) {
            Integer id = ref.fieldId();
            if (ParquetMetricsRowGroupFilter.this.schema.findType(id.intValue()) instanceof Type.NestedType) {
                return true;
            }
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics colStats = this.stats.get(id);
            if (colStats != null && valueCount - colStats.getNumNulls() == 0L) {
                return false;
            }
            return true;
        }

        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                T lower = this.min(colStats, id);
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp >= 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                T lower = this.min(colStats, id);
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                T upper = this.max(colStats, id);
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp <= 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                T upper = this.max(colStats, id);
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            if (ParquetMetricsRowGroupFilter.this.schema.findType(id.intValue()) instanceof Type.NestedType) {
                return true;
            }
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                T lower = this.min(colStats, id);
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return false;
                }
                T upper = this.max(colStats, id);
                cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        public <T> Boolean in(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        public <T> Boolean notIn(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                ByteBuffer prefixAsBytes = lit.toByteBuffer();
                Comparator comparator = Comparators.unsignedBytes();
                Binary lower = (Binary)colStats.genericGetMin();
                int lowerLength = Math.min(prefixAsBytes.remaining(), lower.length());
                int lowerCmp = comparator.compare(BinaryUtil.truncateBinary((ByteBuffer)lower.toByteBuffer(), (int)lowerLength), prefixAsBytes);
                if (lowerCmp > 0) {
                    return false;
                }
                Binary upper = (Binary)colStats.genericGetMax();
                int upperLength = Math.min(prefixAsBytes.remaining(), upper.length());
                int upperCmp = comparator.compare(BinaryUtil.truncateBinary((ByteBuffer)upper.toByteBuffer(), (int)upperLength), prefixAsBytes);
                if (upperCmp < 0) {
                    return false;
                }
            }
            return true;
        }

        private <T> T min(Statistics<?> stats, int id) {
            return (T)this.conversions.get(id).apply(stats.genericGetMin());
        }

        private <T> T max(Statistics<?> stats, int id) {
            return (T)this.conversions.get(id).apply(stats.genericGetMax());
        }
    }
}

