/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;

class ParquetWriter<T>
implements FileAppender<T>,
Closeable {
    private static final DynConstructors.Ctor<PageWriteStore> pageStoreCtor = DynConstructors.builder(PageWriteStore.class).hiddenImpl("org.apache.parquet.hadoop.ColumnChunkPageWriteStore", new Class[]{CodecFactory.BytesCompressor.class, MessageType.class, ByteBufferAllocator.class}).build();
    private static final DynMethods.UnboundMethod flushToWriter = DynMethods.builder((String)"flushToFileWriter").hiddenImpl("org.apache.parquet.hadoop.ColumnChunkPageWriteStore", new Class[]{ParquetFileWriter.class}).build();
    private final OutputFile output;
    private final long targetRowGroupSize;
    private final Map<String, String> metadata;
    private final ParquetProperties props;
    private final CodecFactory.BytesCompressor compressor;
    private final MessageType parquetSchema;
    private final ParquetValueWriter<T> model;
    private final ParquetFileWriter writer;
    private final MetricsConfig metricsConfig;
    private DynMethods.BoundMethod flushPageStoreToWriter;
    private ColumnWriteStore writeStore;
    private long nextRowGroupSize = 0L;
    private long recordCount = 0L;
    private long nextCheckRecordCount = 10L;

    ParquetWriter(Configuration conf, OutputFile output, Schema schema, long rowGroupSize, Map<String, String> metadata, Function<MessageType, ParquetValueWriter<?>> createWriterFunc, CompressionCodecName codec, ParquetProperties properties, MetricsConfig metricsConfig, ParquetFileWriter.Mode writeMode) {
        this.output = output;
        this.targetRowGroupSize = rowGroupSize;
        this.props = properties;
        this.metadata = ImmutableMap.copyOf(metadata);
        this.compressor = new CodecFactory(conf, this.props.getPageSizeThreshold()).getCompressor(codec);
        this.parquetSchema = ParquetSchemaUtil.convert(schema, "table");
        this.model = createWriterFunc.apply(this.parquetSchema);
        this.metricsConfig = metricsConfig;
        try {
            this.writer = new ParquetFileWriter(ParquetIO.file(output, conf), this.parquetSchema, writeMode, rowGroupSize, 0);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create Parquet file", new Object[0]);
        }
        try {
            this.writer.start();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to start Parquet file writer", new Object[0]);
        }
        this.startRowGroup();
    }

    public void add(T value) {
        ++this.recordCount;
        this.model.write(0, value);
        this.writeStore.endRecord();
        this.checkSize();
    }

    public Metrics metrics() {
        return ParquetUtil.footerMetrics(this.writer.getFooter(), this.metricsConfig);
    }

    public long length() {
        try {
            return this.writer.getPos() + this.writeStore.getBufferedSize();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get file length", new Object[0]);
        }
    }

    public List<Long> splitOffsets() {
        return ParquetUtil.getSplitOffsets(this.writer.getFooter());
    }

    private void checkSize() {
        if (this.recordCount >= this.nextCheckRecordCount) {
            double avgRecordSize;
            long bufferedSize = this.writeStore.getBufferedSize();
            if ((double)bufferedSize > (double)this.nextRowGroupSize - 2.0 * (avgRecordSize = (double)bufferedSize / (double)this.recordCount)) {
                this.flushRowGroup(false);
            } else {
                long remainingSpace = this.nextRowGroupSize - bufferedSize;
                long remainingRecords = (long)((double)remainingSpace / avgRecordSize);
                this.nextCheckRecordCount = this.recordCount + Math.min(Math.max(remainingRecords / 2L, 100L), 10000L);
            }
        }
    }

    private void flushRowGroup(boolean finished) {
        try {
            if (this.recordCount > 0L) {
                this.writer.startBlock(this.recordCount);
                this.writeStore.flush();
                this.flushPageStoreToWriter.invoke(new Object[]{this.writer});
                this.writer.endBlock();
                if (!finished) {
                    this.startRowGroup();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to flush row group", new Object[0]);
        }
    }

    private void startRowGroup() {
        try {
            this.nextRowGroupSize = Math.min(this.writer.getNextRowGroupSize(), this.targetRowGroupSize);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        this.nextCheckRecordCount = Math.min(Math.max(this.recordCount / 2L, 100L), 10000L);
        this.recordCount = 0L;
        PageWriteStore pageStore = (PageWriteStore)pageStoreCtor.newInstance(new Object[]{this.compressor, this.parquetSchema, this.props.getAllocator()});
        this.flushPageStoreToWriter = flushToWriter.bind((Object)pageStore);
        this.writeStore = this.props.newColumnWriteStore(this.parquetSchema, pageStore);
        this.model.setColumnStore(this.writeStore);
    }

    @Override
    public void close() throws IOException {
        this.flushRowGroup(true);
        this.writeStore.close();
        this.writer.end(this.metadata);
    }
}

