/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.parquet.Field;
import io.prestosql.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class GroupField
extends Field {
    private final List<Optional<Field>> children;

    public GroupField(Type type, int repetitionLevel, int definitionLevel, boolean required, List<Optional<Field>> children) {
        super(type, repetitionLevel, definitionLevel, required);
        Preconditions.checkArgument((type.getTypeParameters().size() == children.size() ? 1 : 0) != 0, (String)"Type %s has %s parameters, but %s children: %s", (Object)type, (Object)type.getTypeParameters().size(), (Object)children.size(), children);
        this.children = ImmutableList.copyOf((Collection)Objects.requireNonNull(children, "children is null"));
    }

    public List<Optional<Field>> getChildren() {
        return this.children;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("repetitionLevel", this.getRepetitionLevel()).add("definitionLevel", this.getDefinitionLevel()).add("required", this.isRequired()).add("children", this.getChildren().stream().map(field -> field.orElse(null)).collect(Collectors.toList())).toString();
    }
}

