/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet;

import io.airlift.units.DataSize;
import java.util.Objects;

public class ParquetReaderOptions {
    private static final DataSize DEFAULT_MAX_READ_BLOCK_SIZE = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_MAX_MERGE_DISTANCE = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_MAX_BUFFER_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final boolean failOnCorruptedStatistics;
    private final DataSize maxReadBlockSize;
    private final DataSize maxMergeDistance;
    private final DataSize maxBufferSize;

    public ParquetReaderOptions() {
        this.failOnCorruptedStatistics = true;
        this.maxReadBlockSize = DEFAULT_MAX_READ_BLOCK_SIZE;
        this.maxMergeDistance = DEFAULT_MAX_MERGE_DISTANCE;
        this.maxBufferSize = DEFAULT_MAX_BUFFER_SIZE;
    }

    private ParquetReaderOptions(boolean failOnCorruptedStatistics, DataSize maxReadBlockSize, DataSize maxMergeDistance, DataSize maxBufferSize) {
        this.failOnCorruptedStatistics = failOnCorruptedStatistics;
        this.maxReadBlockSize = Objects.requireNonNull(maxReadBlockSize, "maxMergeDistance is null");
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
    }

    @Deprecated
    public boolean isFailOnCorruptedStatistics() {
        return this.failOnCorruptedStatistics;
    }

    public DataSize getMaxReadBlockSize() {
        return this.maxReadBlockSize;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public DataSize getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public ParquetReaderOptions withFailOnCorruptedStatistics(boolean failOnCorruptedStatistics) {
        return new ParquetReaderOptions(failOnCorruptedStatistics, this.maxReadBlockSize, this.maxMergeDistance, this.maxBufferSize);
    }

    public ParquetReaderOptions withMaxReadBlockSize(DataSize maxReadBlockSize) {
        return new ParquetReaderOptions(this.failOnCorruptedStatistics, maxReadBlockSize, this.maxMergeDistance, this.maxBufferSize);
    }

    public ParquetReaderOptions withMaxMergeDistance(DataSize maxMergeDistance) {
        return new ParquetReaderOptions(this.failOnCorruptedStatistics, this.maxReadBlockSize, maxMergeDistance, this.maxBufferSize);
    }

    public ParquetReaderOptions withMaxBufferSize(DataSize maxBufferSize) {
        return new ParquetReaderOptions(this.failOnCorruptedStatistics, this.maxReadBlockSize, this.maxMergeDistance, maxBufferSize);
    }
}

