/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import io.airlift.slice.Slice;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.reader.PrimitiveColumnReader;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DecimalConversions;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;

public class LongDecimalColumnReader
extends PrimitiveColumnReader {
    private final DecimalType parquetDecimalType;

    LongDecimalColumnReader(RichColumnDescriptor descriptor, DecimalType parquetDecimalType) {
        super(descriptor);
        this.parquetDecimalType = Objects.requireNonNull(parquetDecimalType, "parquetDecimalType is null");
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type prestoType) {
        if (!(prestoType instanceof DecimalType)) {
            throw new ParquetDecodingException(String.format("Unsupported Presto column type (%s) for Parquet column (%s)", new Object[]{prestoType, this.columnDescriptor}));
        }
        DecimalType prestoDecimalType = (DecimalType)prestoType;
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            Binary binary = this.valuesReader.readBytes();
            Slice value = Decimals.encodeUnscaledValue((BigInteger)new BigInteger(binary.getBytes()));
            if (prestoDecimalType.isShort()) {
                prestoType.writeLong(blockBuilder, DecimalConversions.longToShortCast((Slice)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)prestoDecimalType.getPrecision(), (long)prestoDecimalType.getScale()));
            } else {
                prestoType.writeSlice(blockBuilder, DecimalConversions.longToLongCast((Slice)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)prestoDecimalType.getPrecision(), (long)prestoDecimalType.getScale()));
            }
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readBytes();
        }
    }
}

