/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.prestosql.parquet.DataPage;
import io.prestosql.parquet.DataPageV1;
import io.prestosql.parquet.DataPageV2;
import io.prestosql.parquet.DictionaryPage;
import io.prestosql.parquet.Field;
import io.prestosql.parquet.ParquetEncoding;
import io.prestosql.parquet.ParquetReaderUtils;
import io.prestosql.parquet.ParquetTypeUtils;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.ValuesType;
import io.prestosql.parquet.dictionary.Dictionary;
import io.prestosql.parquet.reader.BinaryColumnReader;
import io.prestosql.parquet.reader.BooleanColumnReader;
import io.prestosql.parquet.reader.ColumnChunk;
import io.prestosql.parquet.reader.DecimalColumnReaderFactory;
import io.prestosql.parquet.reader.DoubleColumnReader;
import io.prestosql.parquet.reader.FloatColumnReader;
import io.prestosql.parquet.reader.IntColumnReader;
import io.prestosql.parquet.reader.LevelNullReader;
import io.prestosql.parquet.reader.LevelRLEReader;
import io.prestosql.parquet.reader.LevelReader;
import io.prestosql.parquet.reader.LevelValuesReader;
import io.prestosql.parquet.reader.LongColumnReader;
import io.prestosql.parquet.reader.PageReader;
import io.prestosql.parquet.reader.TimestampColumnReader;
import io.prestosql.parquet.reader.TimestampMicrosColumnReader;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.OriginalType;

public abstract class PrimitiveColumnReader {
    private static final int EMPTY_LEVEL_VALUE = -1;
    protected final RichColumnDescriptor columnDescriptor;
    protected int definitionLevel = -1;
    protected int repetitionLevel = -1;
    protected ValuesReader valuesReader;
    private int nextBatchSize;
    private LevelReader repetitionReader;
    private LevelReader definitionReader;
    private long totalValueCount;
    private PageReader pageReader;
    private Dictionary dictionary;
    private int currentValueCount;
    private DataPage page;
    private int remainingValueCountInPage;
    private int readOffset;

    protected abstract void readValue(BlockBuilder var1, Type var2);

    protected abstract void skipValue();

    protected boolean isValueNull() {
        return ParquetTypeUtils.isValueNull(this.columnDescriptor.isRequired(), this.definitionLevel, this.columnDescriptor.getMaxDefinitionLevel());
    }

    public static PrimitiveColumnReader createReader(RichColumnDescriptor descriptor) {
        switch (descriptor.getPrimitiveType().getPrimitiveTypeName()) {
            case BOOLEAN: {
                return new BooleanColumnReader(descriptor);
            }
            case INT32: {
                return PrimitiveColumnReader.createDecimalColumnReader(descriptor).orElse(new IntColumnReader(descriptor));
            }
            case INT64: {
                if (descriptor.getPrimitiveType().getOriginalType() == OriginalType.TIMESTAMP_MICROS) {
                    return new TimestampMicrosColumnReader(descriptor);
                }
                return PrimitiveColumnReader.createDecimalColumnReader(descriptor).orElse(new LongColumnReader(descriptor));
            }
            case INT96: {
                return new TimestampColumnReader(descriptor);
            }
            case FLOAT: {
                return new FloatColumnReader(descriptor);
            }
            case DOUBLE: {
                return new DoubleColumnReader(descriptor);
            }
            case BINARY: {
                return PrimitiveColumnReader.createDecimalColumnReader(descriptor).orElse(new BinaryColumnReader(descriptor));
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return PrimitiveColumnReader.createDecimalColumnReader(descriptor).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, " type FIXED_LEN_BYTE_ARRAY supported as DECIMAL; got " + descriptor.getPrimitiveType().getOriginalType()));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported parquet type: " + descriptor.getPrimitiveType().getPrimitiveTypeName());
    }

    private static Optional<PrimitiveColumnReader> createDecimalColumnReader(RichColumnDescriptor descriptor) {
        return ParquetTypeUtils.createDecimalType(descriptor).map(decimalType -> DecimalColumnReaderFactory.createReader(descriptor, decimalType));
    }

    public PrimitiveColumnReader(RichColumnDescriptor columnDescriptor) {
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor");
        this.pageReader = null;
    }

    public PageReader getPageReader() {
        return this.pageReader;
    }

    public void setPageReader(PageReader pageReader) {
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader");
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(this.columnDescriptor, dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not decode the dictionary for " + (Object)((Object)this.columnDescriptor), (Throwable)e);
            }
        } else {
            this.dictionary = null;
        }
        Preconditions.checkArgument((pageReader.getTotalValueCount() > 0L ? 1 : 0) != 0, (Object)"page is empty");
        this.totalValueCount = pageReader.getTotalValueCount();
    }

    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    public ColumnChunk readPrimitive(Field field) {
        int valueCount;
        int valuesToRead;
        IntArrayList definitionLevels = new IntArrayList();
        IntArrayList repetitionLevels = new IntArrayList();
        this.seek();
        BlockBuilder blockBuilder = field.getType().createBlockBuilder(null, this.nextBatchSize);
        for (valueCount = 0; valueCount < this.nextBatchSize; valueCount += valuesToRead) {
            if (this.page == null) {
                this.readNextPage();
            }
            valuesToRead = Math.min(this.remainingValueCountInPage, this.nextBatchSize - valueCount);
            this.readValues(blockBuilder, valuesToRead, field.getType(), (IntList)definitionLevels, (IntList)repetitionLevels);
        }
        Preconditions.checkArgument((valueCount == this.nextBatchSize ? 1 : 0) != 0, (String)"valueCount %s not equals to batchSize %s", (int)valueCount, (int)this.nextBatchSize);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return new ColumnChunk(blockBuilder.build(), definitionLevels.toIntArray(), repetitionLevels.toIntArray());
    }

    private void readValues(BlockBuilder blockBuilder, int valuesToRead, Type type, IntList definitionLevels, IntList repetitionLevels) {
        this.processValues(valuesToRead, () -> {
            this.readValue(blockBuilder, type);
            definitionLevels.add(this.definitionLevel);
            repetitionLevels.add(this.repetitionLevel);
        });
    }

    private void skipValues(int valuesToRead) {
        this.processValues(valuesToRead, this::skipValue);
    }

    private void processValues(int valuesToRead, Runnable valueReader) {
        if (this.definitionLevel == -1 && this.repetitionLevel == -1) {
            this.definitionLevel = this.definitionReader.readLevel();
            this.repetitionLevel = this.repetitionReader.readLevel();
        }
        int valueCount = 0;
        for (int i = 0; i < valuesToRead; ++i) {
            do {
                valueReader.run();
                if (++valueCount == this.remainingValueCountInPage) {
                    this.updateValueCounts(valueCount);
                    if (!this.readNextPage()) {
                        return;
                    }
                    valueCount = 0;
                }
                this.repetitionLevel = this.repetitionReader.readLevel();
                this.definitionLevel = this.definitionReader.readLevel();
            } while (this.repetitionLevel != 0);
        }
        this.updateValueCounts(valueCount);
    }

    private void seek() {
        int valuePosition;
        int offset;
        Preconditions.checkArgument(((long)this.currentValueCount <= this.totalValueCount ? 1 : 0) != 0, (Object)"Already read all values in column chunk");
        if (this.readOffset == 0) {
            return;
        }
        for (valuePosition = 0; valuePosition < this.readOffset; valuePosition += offset) {
            if (this.page == null) {
                this.readNextPage();
            }
            offset = Math.min(this.remainingValueCountInPage, this.readOffset - valuePosition);
            this.skipValues(offset);
        }
        Preconditions.checkArgument((valuePosition == this.readOffset ? 1 : 0) != 0, (String)"valuePosition %s must be equal to readOffset %s", (int)valuePosition, (int)this.readOffset);
    }

    private boolean readNextPage() {
        Verify.verify((this.page == null ? 1 : 0) != 0, (String)"readNextPage has to be called when page is null", (Object[])new Object[0]);
        this.page = this.pageReader.readPage();
        if (this.page == null) {
            return false;
        }
        this.remainingValueCountInPage = this.page.getValueCount();
        this.valuesReader = this.page instanceof DataPageV1 ? this.readPageV1((DataPageV1)this.page) : this.readPageV2((DataPageV2)this.page);
        return true;
    }

    private void updateValueCounts(int valuesRead) {
        if (valuesRead == this.remainingValueCountInPage) {
            this.page = null;
            this.valuesReader = null;
        }
        this.remainingValueCountInPage -= valuesRead;
        this.currentValueCount += valuesRead;
    }

    private ValuesReader readPageV1(DataPageV1 page) {
        ValuesReader rlReader = page.getRepetitionLevelEncoding().getValuesReader(this.columnDescriptor, ValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDefinitionLevelEncoding().getValuesReader(this.columnDescriptor, ValuesType.DEFINITION_LEVEL);
        this.repetitionReader = new LevelValuesReader(rlReader);
        this.definitionReader = new LevelValuesReader(dlReader);
        try {
            ByteBufferInputStream in = ParquetReaderUtils.toInputStream(page.getSlice());
            rlReader.initFromPage(page.getValueCount(), in);
            dlReader.initFromPage(page.getValueCount(), in);
            return this.initDataReader(page.getValueEncoding(), page.getValueCount(), in);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page " + page + " in column " + (Object)((Object)this.columnDescriptor), (Throwable)e);
        }
    }

    private ValuesReader readPageV2(DataPageV2 page) {
        this.repetitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        return this.initDataReader(page.getDataEncoding(), page.getValueCount(), ParquetReaderUtils.toInputStream(page.getSlice()));
    }

    private LevelReader buildLevelRLEReader(int maxLevel, Slice slice) {
        if (maxLevel == 0) {
            return new LevelNullReader();
        }
        return new LevelRLEReader(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), (InputStream)slice.getInput()));
    }

    private ValuesReader initDataReader(ParquetEncoding dataEncoding, int valueCount, ByteBufferInputStream in) {
        ValuesReader valuesReader;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new ParquetDecodingException("Dictionary is missing for Page");
            }
            valuesReader = dataEncoding.getDictionaryBasedValuesReader(this.columnDescriptor, ValuesType.VALUES, this.dictionary);
        } else {
            valuesReader = dataEncoding.getValuesReader(this.columnDescriptor, ValuesType.VALUES);
        }
        try {
            valuesReader.initFromPage(valueCount, in);
            return valuesReader;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page in column " + (Object)((Object)this.columnDescriptor), (Throwable)e);
        }
    }
}

