/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.reader.PrimitiveColumnReader;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.concurrent.TimeUnit;

public class TimestampMicrosColumnReader
extends PrimitiveColumnReader {
    public TimestampMicrosColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            long utcMillis = TimeUnit.MICROSECONDS.toMillis(this.valuesReader.readLong());
            if (type instanceof TimestampWithTimeZoneType) {
                type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
            } else {
                type.writeLong(blockBuilder, utcMillis);
            }
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readLong();
        }
    }
}

