/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.prestosql.parquet.writer.ColumnChunk;
import io.prestosql.parquet.writer.ColumnWriter;
import io.prestosql.parquet.writer.repdef.DefLevelIterable;
import io.prestosql.parquet.writer.repdef.DefLevelIterables;
import io.prestosql.parquet.writer.repdef.RepLevelIterable;
import io.prestosql.parquet.writer.repdef.RepLevelIterables;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.ColumnarArray;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class ArrayColumnWriter
implements ColumnWriter {
    private final ColumnWriter elementWriter;
    private final int maxDefinitionLevel;
    private final int maxRepetitionLevel;

    public ArrayColumnWriter(ColumnWriter elementWriter, int maxDefinitionLevel, int maxRepetitionLevel) {
        this.elementWriter = Objects.requireNonNull(elementWriter, "elementWriter is null");
        this.maxDefinitionLevel = maxDefinitionLevel;
        this.maxRepetitionLevel = maxRepetitionLevel;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)columnChunk.getBlock());
        this.elementWriter.writeBlock(new ColumnChunk(columnarArray.getElementsBlock(), (List<DefLevelIterable>)ImmutableList.builder().addAll(columnChunk.getDefLevelIterables()).add((Object)DefLevelIterables.of(columnarArray, this.maxDefinitionLevel)).build(), (List<RepLevelIterable>)ImmutableList.builder().addAll(columnChunk.getRepLevelIterables()).add((Object)RepLevelIterables.of(columnarArray, this.maxRepetitionLevel)).build()));
    }

    @Override
    public void close() {
        this.elementWriter.close();
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        return ImmutableList.copyOf(this.elementWriter.getBuffer());
    }

    @Override
    public long getBufferedBytes() {
        return this.elementWriter.getBufferedBytes();
    }

    @Override
    public void reset() {
        this.elementWriter.reset();
    }
}

