/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.parquet.writer.ColumnChunk;
import io.prestosql.parquet.writer.ColumnWriter;
import io.prestosql.parquet.writer.MessageTypeConverter;
import io.prestosql.parquet.writer.ParquetDataOutput;
import io.prestosql.parquet.writer.ParquetSchemaConverter;
import io.prestosql.parquet.writer.ParquetWriterOptions;
import io.prestosql.parquet.writer.ParquetWriters;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;

public class ParquetWriter
implements Closeable {
    private final List<ColumnWriter> columnWriters;
    private final OutputStreamSliceOutput outputStream;
    private final List<Type> types;
    private final ParquetWriterOptions writerOption;
    private final List<String> names;
    private final MessageType messageType;
    private final int chunkMaxLogicalBytes;
    private ImmutableList.Builder<RowGroup> rowGroupBuilder = ImmutableList.builder();
    private int rows;
    private boolean closed;
    private boolean writeHeader;
    public static final Slice MAGIC = Slices.wrappedBuffer((byte[])"PAR1".getBytes(StandardCharsets.US_ASCII));

    public ParquetWriter(OutputStream outputStream, List<String> columnNames, List<Type> types, ParquetWriterOptions writerOption, CompressionCodecName compressionCodecName) {
        this.outputStream = new OutputStreamSliceOutput(Objects.requireNonNull(outputStream, "outputstream is null"));
        this.names = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.writerOption = Objects.requireNonNull(writerOption, "writerOption is null");
        Objects.requireNonNull(compressionCodecName, "compressionCodecName is null");
        Preconditions.checkArgument((types.size() == columnNames.size() ? 1 : 0) != 0, (String)"type size %s is not equal to name size %s", (int)types.size(), (int)columnNames.size());
        ParquetSchemaConverter parquetSchemaConverter = new ParquetSchemaConverter(types, columnNames);
        this.messageType = parquetSchemaConverter.getMessageType();
        ParquetProperties parquetProperties = ParquetProperties.builder().withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0).build();
        this.columnWriters = ParquetWriters.getColumnWriters(this.messageType, parquetSchemaConverter.getPrimitiveTypes(), parquetProperties, compressionCodecName);
        this.chunkMaxLogicalBytes = Math.max(1, writerOption.getMaxBlockSize() / 2);
    }

    public void write(Page page) throws IOException {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"writer is closed");
        if (page.getPositionCount() == 0) {
            return;
        }
        Preconditions.checkArgument((page.getChannelCount() == this.columnWriters.size() ? 1 : 0) != 0);
        while (page != null) {
            int chunkRows = Math.min(page.getPositionCount(), this.writerOption.getRowGroupMaxRowCount());
            Page chunk = page.getRegion(0, chunkRows);
            while (chunkRows > 1 && chunk.getLogicalSizeInBytes() > (long)this.chunkMaxLogicalBytes) {
                chunk = chunk.getRegion(0, chunkRows /= 2);
            }
            page = chunkRows < page.getPositionCount() ? page.getRegion(chunkRows, page.getPositionCount() - chunkRows) : null;
            this.writeChunk(chunk);
        }
    }

    private void writeChunk(Page page) throws IOException {
        long bufferedBytes = 0L;
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            ColumnWriter writer = this.columnWriters.get(channel);
            writer.writeBlock(new ColumnChunk(page.getBlock(channel)));
            bufferedBytes += writer.getBufferedBytes();
        }
        this.rows += page.getPositionCount();
        if (bufferedBytes >= (long)this.writerOption.getMaxBlockSize()) {
            this.columnWriters.forEach(ColumnWriter::close);
            this.flush();
            this.columnWriters.forEach(ColumnWriter::reset);
            this.rows = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.columnWriters.forEach(ColumnWriter::close);
        this.flush();
        this.writeFooter();
        this.outputStream.close();
    }

    private void flush() throws IOException {
        if (!this.writeHeader) {
            ParquetDataOutput.createDataOutput(MAGIC).writeData((SliceOutput)this.outputStream);
            this.writeHeader = true;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnWriter columnWriter : this.columnWriters) {
            columnWriter.getBuffer().forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        ImmutableList bufferDataList = builder.build();
        long stripeStartOffset = this.outputStream.size();
        List metadatas = (List)bufferDataList.stream().map(ColumnWriter.BufferData::getMetaData).collect(ImmutableList.toImmutableList());
        this.updateRowGroups(this.updateColumnMetadataOffset(metadatas, stripeStartOffset));
        bufferDataList.stream().map(ColumnWriter.BufferData::getData).flatMap(Collection::stream).forEach(data -> data.writeData((SliceOutput)this.outputStream));
    }

    private void writeFooter() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        Slice footer = ParquetWriter.getFooter((List<RowGroup>)this.rowGroupBuilder.build(), this.messageType);
        ParquetDataOutput.createDataOutput(footer).writeData((SliceOutput)this.outputStream);
        Slice footerSize = Slices.allocate((int)4);
        footerSize.setInt(0, footer.length());
        ParquetDataOutput.createDataOutput(footerSize).writeData((SliceOutput)this.outputStream);
        ParquetDataOutput.createDataOutput(MAGIC).writeData((SliceOutput)this.outputStream);
    }

    static Slice getFooter(List<RowGroup> rowGroups, MessageType messageType) throws IOException {
        FileMetaData fileMetaData = new FileMetaData();
        fileMetaData.setVersion(1);
        fileMetaData.setSchema(MessageTypeConverter.toParquetSchema(messageType));
        long totalRows = rowGroups.stream().mapToLong(RowGroup::getNum_rows).sum();
        fileMetaData.setNum_rows(totalRows);
        fileMetaData.setRow_groups((List)ImmutableList.copyOf(rowGroups));
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(40);
        Util.writeFileMetaData((FileMetaData)fileMetaData, (OutputStream)dynamicSliceOutput);
        return dynamicSliceOutput.slice();
    }

    private void updateRowGroups(List<ColumnMetaData> columnMetaData) {
        long totalBytes = columnMetaData.stream().mapToLong(ColumnMetaData::getTotal_compressed_size).sum();
        ImmutableList columnChunks = (ImmutableList)columnMetaData.stream().map(ParquetWriter::toColumnChunk).collect(ImmutableList.toImmutableList());
        this.rowGroupBuilder.add((Object)new RowGroup((List)columnChunks, totalBytes, (long)this.rows));
    }

    private static org.apache.parquet.format.ColumnChunk toColumnChunk(ColumnMetaData metaData) {
        org.apache.parquet.format.ColumnChunk columnChunk = new org.apache.parquet.format.ColumnChunk(0L);
        columnChunk.setMeta_data(metaData);
        return columnChunk;
    }

    private List<ColumnMetaData> updateColumnMetadataOffset(List<ColumnMetaData> columns, long offset) {
        ImmutableList.Builder builder = ImmutableList.builder();
        long currentOffset = offset;
        for (ColumnMetaData column : columns) {
            builder.add((Object)new ColumnMetaData(column.type, column.encodings, column.path_in_schema, column.codec, column.num_values, column.total_uncompressed_size, column.total_compressed_size, currentOffset));
            currentOffset += column.getTotal_compressed_size();
        }
        return builder.build();
    }
}

