/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer;

import io.airlift.units.DataSize;
import java.util.Objects;

public class ParquetWriterOptions {
    private static final DataSize DEFAULT_BLOCK_SIZE = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final int DEFAULT_ROW_GROUP_MAX_ROW_COUNT = 10000;
    private final int maxBlockSize;
    private final int rowGroupMaxRowCount;

    public static Builder builder() {
        return new Builder();
    }

    private ParquetWriterOptions(DataSize maxBlockSize, int rowGroupMaxRowCount) {
        this.maxBlockSize = Math.toIntExact(Objects.requireNonNull(maxBlockSize, "maxBlockSize is null").toBytes());
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
    }

    public int getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    static /* synthetic */ DataSize access$000() {
        return DEFAULT_BLOCK_SIZE;
    }

    public static class Builder {
        private DataSize maxBlockSize = ParquetWriterOptions.access$000();
        private int rowGroupMaxRowCount = 10000;

        public Builder setMaxBlockSize(DataSize maxBlockSize) {
            this.maxBlockSize = maxBlockSize;
            return this;
        }

        public Builder setRowGroupMaxRowCount(int rowGroupMaxRowCount) {
            this.rowGroupMaxRowCount = rowGroupMaxRowCount;
            return this;
        }

        public ParquetWriterOptions build() {
            return new ParquetWriterOptions(this.maxBlockSize, this.rowGroupMaxRowCount);
        }
    }
}

