/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.prestosql.parquet.writer.ColumnChunk;
import io.prestosql.parquet.writer.ColumnWriter;
import io.prestosql.parquet.writer.repdef.DefLevelIterable;
import io.prestosql.parquet.writer.repdef.DefLevelIterables;
import io.prestosql.parquet.writer.repdef.RepLevelIterable;
import io.prestosql.parquet.writer.repdef.RepLevelIterables;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.ColumnarRow;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.Preconditions;

public class StructColumnWriter
implements ColumnWriter {
    private final List<ColumnWriter> columnWriters;
    private final int maxDefinitionLevel;
    private final int maxRepetitionLevel;

    public StructColumnWriter(List<ColumnWriter> columnWriters, int maxDefinitionLevel, int maxRepetitionLevel) {
        this.columnWriters = Objects.requireNonNull(columnWriters, "columnWriters is null");
        this.maxDefinitionLevel = maxDefinitionLevel;
        this.maxRepetitionLevel = maxRepetitionLevel;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)columnChunk.getBlock());
        Preconditions.checkArgument((columnarRow.getFieldCount() == this.columnWriters.size() ? 1 : 0) != 0, (String)"ColumnarRow field size %s is not equal to columnWriters size %s", (Object[])new Object[]{columnarRow.getFieldCount(), this.columnWriters.size()});
        ImmutableList defLevelIterables = ImmutableList.builder().addAll(columnChunk.getDefLevelIterables()).add((Object)DefLevelIterables.of(columnarRow, this.maxDefinitionLevel)).build();
        ImmutableList repLevelIterables = ImmutableList.builder().addAll(columnChunk.getRepLevelIterables()).add((Object)RepLevelIterables.of(columnChunk.getBlock())).build();
        for (int i = 0; i < this.columnWriters.size(); ++i) {
            ColumnWriter columnWriter = this.columnWriters.get(i);
            Block block = columnarRow.getField(i);
            columnWriter.writeBlock(new ColumnChunk(block, (List<DefLevelIterable>)defLevelIterables, (List<RepLevelIterable>)repLevelIterables));
        }
    }

    @Override
    public void close() {
        this.columnWriters.forEach(ColumnWriter::close);
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnWriter columnWriter : this.columnWriters) {
            builder.addAll(columnWriter.getBuffer());
        }
        return builder.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.columnWriters.stream().mapToLong(ColumnWriter::getBufferedBytes).sum();
    }

    @Override
    public void reset() {
        this.columnWriters.forEach(ColumnWriter::reset);
    }
}

