/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer.repdef;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.prestosql.parquet.writer.repdef.DefLevelIterable;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.ColumnarArray;
import io.prestosql.spi.block.ColumnarMap;
import io.prestosql.spi.block.ColumnarRow;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public class DefLevelIterables {
    private DefLevelIterables() {
    }

    public static DefLevelIterable of(Block block, int maxDefinitionLevel) {
        return new PrimitiveDefLevelIterable(block, maxDefinitionLevel);
    }

    public static DefLevelIterable of(ColumnarRow columnarRow, int maxDefinitionLevel) {
        return new ColumnRowDefLevelIterable(columnarRow, maxDefinitionLevel);
    }

    public static DefLevelIterable of(ColumnarArray columnarArray, int maxDefinitionLevel) {
        return new ColumnArrayDefLevelIterable(columnarArray, maxDefinitionLevel);
    }

    public static DefLevelIterable of(ColumnarMap columnarMap, int maxDefinitionLevel) {
        return new ColumnMapDefLevelIterable(columnarMap, maxDefinitionLevel);
    }

    public static Iterator<Integer> getIterator(List<DefLevelIterable> iterables) {
        return new NestedDefLevelIterator(iterables);
    }

    static class NestedDefLevelIterator
    extends AbstractIterator<Integer> {
        private final List<DefLevelIterable.DefLevelIterator> iterators;
        private int iteratorIndex;

        NestedDefLevelIterator(List<DefLevelIterable> iterables) {
            this.iterators = (List)iterables.stream().map(DefLevelIterable::getIterator).collect(ImmutableList.toImmutableList());
        }

        protected Integer computeNext() {
            DefLevelIterable.DefLevelIterator current = this.iterators.get(this.iteratorIndex);
            while (this.iteratorIndex > 0 && current.end()) {
                --this.iteratorIndex;
                current = this.iterators.get(this.iteratorIndex);
            }
            while (current.hasNext()) {
                OptionalInt next = (OptionalInt)current.next();
                if (next.isPresent()) {
                    return next.getAsInt();
                }
                ++this.iteratorIndex;
                current = this.iterators.get(this.iteratorIndex);
            }
            Preconditions.checkState((boolean)this.iterators.stream().noneMatch(AbstractIterator::hasNext));
            return (Integer)this.endOfData();
        }
    }

    static class ColumnArrayDefLevelIterable
    implements DefLevelIterable {
        private final ColumnarArray columnarArray;
        private final int maxDefinitionLevel;

        ColumnArrayDefLevelIterable(ColumnarArray columnarArray, int maxDefinitionLevel) {
            this.columnarArray = Objects.requireNonNull(columnarArray, "columnarArray is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefLevelIterable.DefLevelIterator getIterator() {
            return new DefLevelIterable.DefLevelIterator(){
                private int position = -1;
                private Iterator<OptionalInt> iterator;

                @Override
                boolean end() {
                    return this.iterator == null || !this.iterator.hasNext();
                }

                protected OptionalInt computeNext() {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        return this.iterator.next();
                    }
                    ++this.position;
                    if (this.position == columnarArray.getPositionCount()) {
                        return (OptionalInt)this.endOfData();
                    }
                    if (columnarArray.isNull(this.position)) {
                        return OptionalInt.of(maxDefinitionLevel - 2);
                    }
                    int arrayLength = columnarArray.getLength(this.position);
                    if (arrayLength == 0) {
                        return OptionalInt.of(maxDefinitionLevel - 1);
                    }
                    this.iterator = Collections.nCopies(arrayLength, OptionalInt.empty()).iterator();
                    return this.iterator.next();
                }
            };
        }
    }

    static class ColumnMapDefLevelIterable
    implements DefLevelIterable {
        private final ColumnarMap columnarMap;
        private final int maxDefinitionLevel;

        ColumnMapDefLevelIterable(ColumnarMap columnarMap, int maxDefinitionLevel) {
            this.columnarMap = Objects.requireNonNull(columnarMap, "columnarMap is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefLevelIterable.DefLevelIterator getIterator() {
            return new DefLevelIterable.DefLevelIterator(){
                private int position = -1;
                private Iterator<OptionalInt> iterator;

                @Override
                boolean end() {
                    return this.iterator == null || !this.iterator.hasNext();
                }

                protected OptionalInt computeNext() {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        return this.iterator.next();
                    }
                    ++this.position;
                    if (this.position == columnarMap.getPositionCount()) {
                        return (OptionalInt)this.endOfData();
                    }
                    if (columnarMap.isNull(this.position)) {
                        return OptionalInt.of(maxDefinitionLevel - 2);
                    }
                    int arrayLength = columnarMap.getEntryCount(this.position);
                    if (arrayLength == 0) {
                        return OptionalInt.of(maxDefinitionLevel - 1);
                    }
                    this.iterator = Collections.nCopies(arrayLength, OptionalInt.empty()).iterator();
                    return this.iterator.next();
                }
            };
        }
    }

    static class ColumnRowDefLevelIterable
    implements DefLevelIterable {
        private final ColumnarRow columnarRow;
        private final int maxDefinitionLevel;

        ColumnRowDefLevelIterable(ColumnarRow columnarRow, int maxDefinitionLevel) {
            this.columnarRow = Objects.requireNonNull(columnarRow, "columnarRow is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefLevelIterable.DefLevelIterator getIterator() {
            return new DefLevelIterable.DefLevelIterator(){
                private int position = -1;

                @Override
                boolean end() {
                    return true;
                }

                protected OptionalInt computeNext() {
                    ++this.position;
                    if (this.position == columnarRow.getPositionCount()) {
                        return (OptionalInt)this.endOfData();
                    }
                    if (columnarRow.isNull(this.position)) {
                        return OptionalInt.of(maxDefinitionLevel - 1);
                    }
                    return OptionalInt.empty();
                }
            };
        }
    }

    static class PrimitiveDefLevelIterable
    implements DefLevelIterable {
        private final Block block;
        private final int maxDefinitionLevel;

        PrimitiveDefLevelIterable(Block block, int maxDefinitionLevel) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefLevelIterable.DefLevelIterator getIterator() {
            return new DefLevelIterable.DefLevelIterator(){
                private int position = -1;

                @Override
                boolean end() {
                    return true;
                }

                protected OptionalInt computeNext() {
                    ++this.position;
                    if (this.position == block.getPositionCount()) {
                        return (OptionalInt)this.endOfData();
                    }
                    if (block.isNull(this.position)) {
                        return OptionalInt.of(maxDefinitionLevel - 1);
                    }
                    return OptionalInt.of(maxDefinitionLevel);
                }
            };
        }
    }
}

