/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.writer.valuewriter;

import io.prestosql.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.BooleanType;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class BooleanValueWriter
extends PrimitiveValueWriter {
    private final ValuesWriter valuesWriter;

    public BooleanValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.valuesWriter = Objects.requireNonNull(valuesWriter, "valuesWriter is null");
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            boolean value = BooleanType.BOOLEAN.getBoolean(block, i);
            this.valuesWriter.writeBoolean(value);
            this.getStatistics().updateStats(value);
        }
    }
}

