/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.log4j;

import com.google.common.flogger.LogSite;
import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.SimpleMessageFormatter;
import com.google.common.flogger.backend.log4j.Log4jLoggerBackend;
import com.google.common.flogger.backend.log4j.LogDataFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

final class SimpleLogEvent
implements SimpleMessageFormatter.SimpleLogHandler {
    private final Logger logger;
    private final LogData logData;
    private org.apache.log4j.Level level;
    private String message;
    private Throwable thrown;

    static SimpleLogEvent create(Logger logger, LogData data) {
        return new SimpleLogEvent(logger, data);
    }

    static SimpleLogEvent error(Logger logger, RuntimeException error, LogData data) {
        return new SimpleLogEvent(logger, error, data);
    }

    private SimpleLogEvent(Logger logger, LogData logData) {
        this.logger = logger;
        this.logData = logData;
        LogDataFormatter.format(logData, this);
    }

    private SimpleLogEvent(Logger logger, RuntimeException error, LogData badLogData) {
        this.logger = logger;
        this.logData = badLogData;
        LogDataFormatter.formatBadLogData(error, badLogData, this);
    }

    public void handleFormattedLogMessage(Level level, String message, Throwable thrown) {
        this.level = Log4jLoggerBackend.toLog4jLevel(level);
        this.message = message;
        this.thrown = thrown;
    }

    org.apache.log4j.Level getLevel() {
        return this.level;
    }

    LoggingEvent asLoggingEvent() {
        String fqnOfCategoryClass = null;
        String nestedDiagnosticContext = "";
        Map mdcProperties = Collections.emptyMap();
        return new LoggingEvent(fqnOfCategoryClass, (Category)this.logger, TimeUnit.NANOSECONDS.toMillis(this.logData.getTimestampNanos()), this.level, (Object)this.message, Thread.currentThread().getName(), this.thrown != null ? new ThrowableInformation(this.thrown) : null, nestedDiagnosticContext, this.getLocationInfo(), mdcProperties);
    }

    private LocationInfo getLocationInfo() {
        LogSite logSite = this.logData.getLogSite();
        return new LocationInfo(logSite.getFileName(), logSite.getClassName(), logSite.getMethodName(), Integer.toString(logSite.getLineNumber()));
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getClass().getSimpleName()).append(" {\n  message: ").append(this.message).append('\n');
        LogDataFormatter.appendLogData(this.logData, out);
        out.append("\n}");
        return out.toString();
    }
}

