/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.collections.DirectedAcyclicGraphNode;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@NotThreadSafe
public class DirectedAcyclicGraph<T> {
    private final List<DirectedAcyclicGraphNode<T>> mRoots = new ArrayList<DirectedAcyclicGraphNode<T>>();
    private final Map<T, DirectedAcyclicGraphNode<T>> mIndex = new HashMap<T, DirectedAcyclicGraphNode<T>>();

    public void add(T payload, List<T> parents) {
        Preconditions.checkState(!this.contains(payload), "the payload already exists in the DAG");
        DirectedAcyclicGraphNode<T> newNode = new DirectedAcyclicGraphNode<T>(payload);
        this.mIndex.put(payload, newNode);
        if (parents.isEmpty()) {
            this.mRoots.add(newNode);
        } else {
            for (T parent : parents) {
                Preconditions.checkState(this.contains(parent), "the parent payload " + parent + " does not exist in the DAG");
                DirectedAcyclicGraphNode<T> parentNode = this.mIndex.get(parent);
                parentNode.addChild(newNode);
                newNode.addParent(parentNode);
            }
        }
    }

    public void deleteLeaf(T payload) {
        Preconditions.checkState(this.contains(payload), "the node does not exist");
        DirectedAcyclicGraphNode<T> node = this.mIndex.get(payload);
        Preconditions.checkState(node.getChildren().isEmpty(), "the node is not a leaf");
        for (DirectedAcyclicGraphNode<T> parent : node.getParents()) {
            parent.removeChild(node);
        }
        this.mIndex.remove(payload);
        if (node.getParents().isEmpty()) {
            this.mRoots.remove(node);
        }
    }

    public boolean contains(T payload) {
        return this.mIndex.containsKey(payload);
    }

    public List<T> getChildren(T payload) {
        ArrayList<T> children = new ArrayList<T>();
        if (!this.mIndex.containsKey(payload)) {
            return children;
        }
        DirectedAcyclicGraphNode<T> node = this.mIndex.get(payload);
        for (DirectedAcyclicGraphNode<T> child : node.getChildren()) {
            children.add(child.getPayload());
        }
        return children;
    }

    public List<T> getParents(T payload) {
        ArrayList<T> parents = new ArrayList<T>();
        if (!this.mIndex.containsKey(payload)) {
            return parents;
        }
        DirectedAcyclicGraphNode<T> node = this.mIndex.get(payload);
        for (DirectedAcyclicGraphNode<T> parent : node.getParents()) {
            parents.add(parent.getPayload());
        }
        return parents;
    }

    public boolean isRoot(T payload) {
        if (!this.contains(payload)) {
            return false;
        }
        return this.mRoots.contains(this.mIndex.get(payload));
    }

    public List<T> getRoots() {
        ArrayList<T> roots = new ArrayList<T>();
        for (DirectedAcyclicGraphNode<T> root : this.mRoots) {
            roots.add(root.getPayload());
        }
        return roots;
    }

    public List<T> sortTopologically(Set<T> payloads) {
        ArrayList result = new ArrayList();
        HashSet<T> input = new HashSet<T>(payloads);
        ArrayDeque<DirectedAcyclicGraphNode<T>> toVisit = new ArrayDeque<DirectedAcyclicGraphNode<T>>(this.mRoots);
        while (!toVisit.isEmpty()) {
            DirectedAcyclicGraphNode visit = (DirectedAcyclicGraphNode)toVisit.removeFirst();
            Object payload = visit.getPayload();
            if (input.remove(payload)) {
                result.add(visit.getPayload());
            }
            toVisit.addAll(visit.getChildren());
        }
        Preconditions.checkState(input.isEmpty(), "Not all the given payloads are in the DAG: ", input);
        return result;
    }

    public List<T> getAllInTopologicalOrder() {
        return this.sortTopologically(this.mIndex.keySet());
    }
}

