/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.internal;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.base.Strings;
import alluxio.shaded.client.com.google.common.base.Verify;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ClientCall;
import alluxio.shaded.client.io.grpc.ClientInterceptor;
import alluxio.shaded.client.io.grpc.Deadline;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.internal.HedgingPolicy;
import alluxio.shaded.client.io.grpc.internal.RetryPolicy;
import alluxio.shaded.client.io.grpc.internal.ServiceConfigUtil;
import alluxio.shaded.client.javax.annotation.CheckForNull;
import alluxio.shaded.client.javax.annotation.Nonnull;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ServiceConfigInterceptor
implements ClientInterceptor {
    private static final Logger logger = Logger.getLogger(ServiceConfigInterceptor.class.getName());
    @VisibleForTesting
    final AtomicReference<Map<String, MethodInfo>> serviceMethodMap = new AtomicReference();
    @VisibleForTesting
    final AtomicReference<Map<String, MethodInfo>> serviceMap = new AtomicReference();
    private final boolean retryEnabled;
    private final int maxRetryAttemptsLimit;
    private final int maxHedgedAttemptsLimit;
    private volatile boolean nameResolveComplete;
    static final CallOptions.Key<RetryPolicy.Provider> RETRY_POLICY_KEY = CallOptions.Key.create("internal-retry-policy");
    static final CallOptions.Key<HedgingPolicy.Provider> HEDGING_POLICY_KEY = CallOptions.Key.create("internal-hedging-policy");

    ServiceConfigInterceptor(boolean retryEnabled, int maxRetryAttemptsLimit, int maxHedgedAttemptsLimit) {
        this.retryEnabled = retryEnabled;
        this.maxRetryAttemptsLimit = maxRetryAttemptsLimit;
        this.maxHedgedAttemptsLimit = maxHedgedAttemptsLimit;
    }

    void handleUpdate(@Nonnull Map<String, Object> serviceConfig) {
        HashMap<String, MethodInfo> newServiceMethodConfigs = new HashMap<String, MethodInfo>();
        HashMap<String, MethodInfo> newServiceConfigs = new HashMap<String, MethodInfo>();
        List<Map<String, Object>> methodConfigs = ServiceConfigUtil.getMethodConfigFromServiceConfig(serviceConfig);
        if (methodConfigs == null) {
            logger.log(Level.FINE, "No method configs found, skipping");
            this.nameResolveComplete = true;
            return;
        }
        for (Map<String, Object> methodConfig : methodConfigs) {
            MethodInfo info = new MethodInfo(methodConfig, this.retryEnabled, this.maxRetryAttemptsLimit, this.maxHedgedAttemptsLimit);
            List<Map<String, Object>> nameList = ServiceConfigUtil.getNameListFromMethodConfig(methodConfig);
            Preconditions.checkArgument(nameList != null && !nameList.isEmpty(), "no names in method config %s", methodConfig);
            for (Map<String, Object> name : nameList) {
                String serviceName = ServiceConfigUtil.getServiceFromName(name);
                Preconditions.checkArgument(!Strings.isNullOrEmpty(serviceName), "missing service name");
                String methodName = ServiceConfigUtil.getMethodFromName(name);
                if (Strings.isNullOrEmpty(methodName)) {
                    Preconditions.checkArgument(!newServiceConfigs.containsKey(serviceName), "Duplicate service %s", (Object)serviceName);
                    newServiceConfigs.put(serviceName, info);
                    continue;
                }
                String fullMethodName = MethodDescriptor.generateFullMethodName(serviceName, methodName);
                Preconditions.checkArgument(!newServiceMethodConfigs.containsKey(fullMethodName), "Duplicate method name %s", (Object)fullMethodName);
                newServiceMethodConfigs.put(fullMethodName, info);
            }
        }
        this.serviceMethodMap.set(Collections.unmodifiableMap(newServiceMethodConfigs));
        this.serviceMap.set(Collections.unmodifiableMap(newServiceConfigs));
        this.nameResolveComplete = true;
    }

    private static HedgingPolicy hedgingPolicy(Map<String, Object> hedgingPolicy, int maxAttemptsLimit) {
        int maxAttempts = Preconditions.checkNotNull(ServiceConfigUtil.getMaxAttemptsFromHedgingPolicy(hedgingPolicy), "maxAttempts cannot be empty");
        Preconditions.checkArgument(maxAttempts >= 2, "maxAttempts must be greater than 1: %s", maxAttempts);
        maxAttempts = Math.min(maxAttempts, maxAttemptsLimit);
        long hedgingDelayNanos = Preconditions.checkNotNull(ServiceConfigUtil.getHedgingDelayNanosFromHedgingPolicy(hedgingPolicy), "hedgingDelay cannot be empty");
        Preconditions.checkArgument(hedgingDelayNanos >= 0L, "hedgingDelay must not be negative: %s", hedgingDelayNanos);
        List<String> rawCodes = ServiceConfigUtil.getNonFatalStatusCodesFromHedgingPolicy(hedgingPolicy);
        Preconditions.checkNotNull(rawCodes, "rawCodes must be present");
        Preconditions.checkArgument(!rawCodes.isEmpty(), "rawCodes can't be empty");
        EnumSet<Status.Code> codes = EnumSet.noneOf(Status.Code.class);
        for (String rawCode : rawCodes) {
            Verify.verify(!"OK".equals(rawCode), "rawCode can not be \"OK\"", new Object[0]);
            codes.add(Status.Code.valueOf(rawCode));
        }
        Set<Status.Code> nonFatalStatusCodes = Collections.unmodifiableSet(codes);
        return new HedgingPolicy(maxAttempts, hedgingDelayNanos, nonFatalStatusCodes);
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        Integer existingLimit;
        MethodInfo info;
        if (this.retryEnabled) {
            if (this.nameResolveComplete) {
                final RetryPolicy retryPolicy = this.getRetryPolicyFromConfig(method);
                final HedgingPolicy hedgingPolicy = this.getHedgingPolicyFromConfig(method);
                Verify.verify(retryPolicy.equals(RetryPolicy.DEFAULT) || hedgingPolicy.equals(HedgingPolicy.DEFAULT), "Can not apply both retry and hedging policy for the method '%s'", method);
                final class ImmediateRetryPolicyProvider
                implements RetryPolicy.Provider {
                    ImmediateRetryPolicyProvider() {
                    }

                    @Override
                    public RetryPolicy get() {
                        return retryPolicy;
                    }
                }
                final class ImmediateHedgingPolicyProvider
                implements HedgingPolicy.Provider {
                    ImmediateHedgingPolicyProvider() {
                    }

                    @Override
                    public HedgingPolicy get() {
                        return hedgingPolicy;
                    }
                }
                callOptions = callOptions.withOption(RETRY_POLICY_KEY, new ImmediateRetryPolicyProvider()).withOption(HEDGING_POLICY_KEY, new ImmediateHedgingPolicyProvider());
            } else {
                final class DelayedRetryPolicyProvider
                implements RetryPolicy.Provider {
                    DelayedRetryPolicyProvider() {
                    }

                    @Override
                    public RetryPolicy get() {
                        if (!ServiceConfigInterceptor.this.nameResolveComplete) {
                            return RetryPolicy.DEFAULT;
                        }
                        return ServiceConfigInterceptor.this.getRetryPolicyFromConfig(method);
                    }
                }
                final class DelayedHedgingPolicyProvider
                implements HedgingPolicy.Provider {
                    DelayedHedgingPolicyProvider() {
                    }

                    @Override
                    public HedgingPolicy get() {
                        if (!ServiceConfigInterceptor.this.nameResolveComplete) {
                            return HedgingPolicy.DEFAULT;
                        }
                        HedgingPolicy hedgingPolicy = ServiceConfigInterceptor.this.getHedgingPolicyFromConfig(method);
                        Verify.verify(hedgingPolicy.equals(HedgingPolicy.DEFAULT) || ServiceConfigInterceptor.this.getRetryPolicyFromConfig(method).equals(RetryPolicy.DEFAULT), "Can not apply both retry and hedging policy for the method '%s'", (Object)method);
                        return hedgingPolicy;
                    }
                }
                callOptions = callOptions.withOption(RETRY_POLICY_KEY, new DelayedRetryPolicyProvider()).withOption(HEDGING_POLICY_KEY, new DelayedHedgingPolicyProvider());
            }
        }
        if ((info = this.getMethodInfo(method)) == null) {
            return next.newCall(method, callOptions);
        }
        if (info.timeoutNanos != null) {
            Deadline newDeadline = Deadline.after(info.timeoutNanos, TimeUnit.NANOSECONDS);
            Deadline existingDeadline = callOptions.getDeadline();
            if (existingDeadline == null || newDeadline.compareTo(existingDeadline) < 0) {
                callOptions = callOptions.withDeadline(newDeadline);
            }
        }
        if (info.waitForReady != null) {
            CallOptions callOptions2 = callOptions = info.waitForReady != false ? callOptions.withWaitForReady() : callOptions.withoutWaitForReady();
        }
        if (info.maxInboundMessageSize != null) {
            existingLimit = callOptions.getMaxInboundMessageSize();
            callOptions = existingLimit != null ? callOptions.withMaxInboundMessageSize(Math.min(existingLimit, info.maxInboundMessageSize)) : callOptions.withMaxInboundMessageSize(info.maxInboundMessageSize);
        }
        if (info.maxOutboundMessageSize != null) {
            existingLimit = callOptions.getMaxOutboundMessageSize();
            callOptions = existingLimit != null ? callOptions.withMaxOutboundMessageSize(Math.min(existingLimit, info.maxOutboundMessageSize)) : callOptions.withMaxOutboundMessageSize(info.maxOutboundMessageSize);
        }
        return next.newCall(method, callOptions);
    }

    @CheckForNull
    private MethodInfo getMethodInfo(MethodDescriptor<?, ?> method) {
        Map<String, MethodInfo> localServiceMap;
        Map<String, MethodInfo> localServiceMethodMap = this.serviceMethodMap.get();
        MethodInfo info = null;
        if (localServiceMethodMap != null) {
            info = localServiceMethodMap.get(method.getFullMethodName());
        }
        if (info == null && (localServiceMap = this.serviceMap.get()) != null) {
            info = localServiceMap.get(MethodDescriptor.extractFullServiceName(method.getFullMethodName()));
        }
        return info;
    }

    @VisibleForTesting
    RetryPolicy getRetryPolicyFromConfig(MethodDescriptor<?, ?> method) {
        MethodInfo info = this.getMethodInfo(method);
        return info == null ? RetryPolicy.DEFAULT : info.retryPolicy;
    }

    @VisibleForTesting
    HedgingPolicy getHedgingPolicyFromConfig(MethodDescriptor<?, ?> method) {
        MethodInfo info = this.getMethodInfo(method);
        return info == null ? HedgingPolicy.DEFAULT : info.hedgingPolicy;
    }

    static final class MethodInfo {
        final Long timeoutNanos;
        final Boolean waitForReady;
        final Integer maxInboundMessageSize;
        final Integer maxOutboundMessageSize;
        final RetryPolicy retryPolicy;
        final HedgingPolicy hedgingPolicy;

        MethodInfo(Map<String, Object> methodConfig, boolean retryEnabled, int maxRetryAttemptsLimit, int maxHedgedAttemptsLimit) {
            this.timeoutNanos = ServiceConfigUtil.getTimeoutFromMethodConfig(methodConfig);
            this.waitForReady = ServiceConfigUtil.getWaitForReadyFromMethodConfig(methodConfig);
            this.maxInboundMessageSize = ServiceConfigUtil.getMaxResponseMessageBytesFromMethodConfig(methodConfig);
            if (this.maxInboundMessageSize != null) {
                Preconditions.checkArgument(this.maxInboundMessageSize >= 0, "maxInboundMessageSize %s exceeds bounds", (Object)this.maxInboundMessageSize);
            }
            this.maxOutboundMessageSize = ServiceConfigUtil.getMaxRequestMessageBytesFromMethodConfig(methodConfig);
            if (this.maxOutboundMessageSize != null) {
                Preconditions.checkArgument(this.maxOutboundMessageSize >= 0, "maxOutboundMessageSize %s exceeds bounds", (Object)this.maxOutboundMessageSize);
            }
            Map<String, Object> retryPolicyMap = retryEnabled ? ServiceConfigUtil.getRetryPolicyFromMethodConfig(methodConfig) : null;
            this.retryPolicy = retryPolicyMap == null ? RetryPolicy.DEFAULT : MethodInfo.retryPolicy(retryPolicyMap, maxRetryAttemptsLimit);
            Map<String, Object> hedgingPolicyMap = retryEnabled ? ServiceConfigUtil.getHedgingPolicyFromMethodConfig(methodConfig) : null;
            this.hedgingPolicy = hedgingPolicyMap == null ? HedgingPolicy.DEFAULT : ServiceConfigInterceptor.hedgingPolicy(hedgingPolicyMap, maxHedgedAttemptsLimit);
        }

        public int hashCode() {
            return Objects.hashCode(this.timeoutNanos, this.waitForReady, this.maxInboundMessageSize, this.maxOutboundMessageSize, this.retryPolicy);
        }

        public boolean equals(Object other) {
            if (!(other instanceof MethodInfo)) {
                return false;
            }
            MethodInfo that = (MethodInfo)other;
            return Objects.equal(this.timeoutNanos, that.timeoutNanos) && Objects.equal(this.waitForReady, that.waitForReady) && Objects.equal(this.maxInboundMessageSize, that.maxInboundMessageSize) && Objects.equal(this.maxOutboundMessageSize, that.maxOutboundMessageSize) && Objects.equal(this.retryPolicy, that.retryPolicy);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("timeoutNanos", this.timeoutNanos).add("waitForReady", this.waitForReady).add("maxInboundMessageSize", this.maxInboundMessageSize).add("maxOutboundMessageSize", this.maxOutboundMessageSize).add("retryPolicy", this.retryPolicy).toString();
        }

        private static RetryPolicy retryPolicy(Map<String, Object> retryPolicy, int maxAttemptsLimit) {
            int maxAttempts = Preconditions.checkNotNull(ServiceConfigUtil.getMaxAttemptsFromRetryPolicy(retryPolicy), "maxAttempts cannot be empty");
            Preconditions.checkArgument(maxAttempts >= 2, "maxAttempts must be greater than 1: %s", maxAttempts);
            maxAttempts = Math.min(maxAttempts, maxAttemptsLimit);
            long initialBackoffNanos = Preconditions.checkNotNull(ServiceConfigUtil.getInitialBackoffNanosFromRetryPolicy(retryPolicy), "initialBackoff cannot be empty");
            Preconditions.checkArgument(initialBackoffNanos > 0L, "initialBackoffNanos must be greater than 0: %s", initialBackoffNanos);
            long maxBackoffNanos = Preconditions.checkNotNull(ServiceConfigUtil.getMaxBackoffNanosFromRetryPolicy(retryPolicy), "maxBackoff cannot be empty");
            Preconditions.checkArgument(maxBackoffNanos > 0L, "maxBackoff must be greater than 0: %s", maxBackoffNanos);
            double backoffMultiplier = Preconditions.checkNotNull(ServiceConfigUtil.getBackoffMultiplierFromRetryPolicy(retryPolicy), "backoffMultiplier cannot be empty");
            Preconditions.checkArgument(backoffMultiplier > 0.0, "backoffMultiplier must be greater than 0: %s", (Object)backoffMultiplier);
            List<String> rawCodes = ServiceConfigUtil.getRetryableStatusCodesFromRetryPolicy(retryPolicy);
            Preconditions.checkNotNull(rawCodes, "rawCodes must be present");
            Preconditions.checkArgument(!rawCodes.isEmpty(), "rawCodes can't be empty");
            EnumSet<Status.Code> codes = EnumSet.noneOf(Status.Code.class);
            for (String rawCode : rawCodes) {
                Verify.verify(!"OK".equals(rawCode), "rawCode can not be \"OK\"", new Object[0]);
                codes.add(Status.Code.valueOf(rawCode));
            }
            Set<Status.Code> retryableStatusCodes = Collections.unmodifiableSet(codes);
            return new RetryPolicy(maxAttempts, initialBackoffNanos, maxBackoffNanos, backoffMultiplier, retryableStatusCodes);
        }
    }
}

