/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.commons.httpclient.auth;

import alluxio.shaded.client.org.apache.commons.httpclient.Header;
import alluxio.shaded.client.org.apache.commons.httpclient.NameValuePair;
import alluxio.shaded.client.org.apache.commons.httpclient.auth.MalformedChallengeException;
import alluxio.shaded.client.org.apache.commons.httpclient.util.ParameterParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AuthChallengeParser {
    public static String extractScheme(String challengeStr) throws MalformedChallengeException {
        if (challengeStr == null) {
            throw new IllegalArgumentException("Challenge may not be null");
        }
        int idx = challengeStr.indexOf(32);
        String s2 = null;
        s2 = idx == -1 ? challengeStr : challengeStr.substring(0, idx);
        if (s2.equals("")) {
            throw new MalformedChallengeException("Invalid challenge: " + challengeStr);
        }
        return s2.toLowerCase();
    }

    public static Map extractParams(String challengeStr) throws MalformedChallengeException {
        if (challengeStr == null) {
            throw new IllegalArgumentException("Challenge may not be null");
        }
        int idx = challengeStr.indexOf(32);
        if (idx == -1) {
            throw new MalformedChallengeException("Invalid challenge: " + challengeStr);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ParameterParser parser = new ParameterParser();
        List params = parser.parse(challengeStr.substring(idx + 1, challengeStr.length()), ',');
        for (int i = 0; i < params.size(); ++i) {
            NameValuePair param = (NameValuePair)params.get(i);
            map.put(param.getName().toLowerCase(), param.getValue());
        }
        return map;
    }

    public static Map parseChallenges(Header[] headers) throws MalformedChallengeException {
        if (headers == null) {
            throw new IllegalArgumentException("Array of challenges may not be null");
        }
        String challenge = null;
        HashMap<String, String> challengemap = new HashMap<String, String>(headers.length);
        for (int i = 0; i < headers.length; ++i) {
            challenge = headers[i].getValue();
            String s2 = AuthChallengeParser.extractScheme(challenge);
            challengemap.put(s2, challenge);
        }
        return challengemap;
    }
}

