/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.options;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class OpenOptions {
    private long mOffset = 0L;
    private long mLength = Long.MAX_VALUE;
    private boolean mRecoverFailedOpen = false;

    public static OpenOptions defaults() {
        return new OpenOptions();
    }

    private OpenOptions() {
    }

    public long getOffset() {
        return this.mOffset;
    }

    public long getLength() {
        return this.mLength;
    }

    public boolean getRecoverFailedOpen() {
        return this.mRecoverFailedOpen;
    }

    public OpenOptions setOffset(long offset) {
        this.mOffset = offset;
        return this;
    }

    public OpenOptions setLength(long length) {
        this.mLength = length;
        return this;
    }

    public OpenOptions setRecoverFailedOpen(boolean recover) {
        this.mRecoverFailedOpen = recover;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenOptions)) {
            return false;
        }
        OpenOptions that = (OpenOptions)o;
        return Objects.equal(this.mOffset, that.mOffset) && Objects.equal(this.mLength, that.mLength) && Objects.equal(this.mRecoverFailedOpen, that.mRecoverFailedOpen);
    }

    public int hashCode() {
        return Objects.hashCode(this.mOffset, this.mLength, this.mRecoverFailedOpen);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("offset", this.mOffset).add("length", this.mLength).add("recoverFailedOpen", this.mRecoverFailedOpen).toString();
    }
}

