/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.network;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.network.ChannelType;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import alluxio.shaded.client.io.netty.channel.ServerChannel;
import alluxio.shaded.client.io.netty.channel.epoll.Epoll;
import alluxio.shaded.client.io.netty.channel.epoll.EpollChannelOption;
import alluxio.shaded.client.io.netty.channel.epoll.EpollDomainSocketChannel;
import alluxio.shaded.client.io.netty.channel.epoll.EpollEventLoopGroup;
import alluxio.shaded.client.io.netty.channel.epoll.EpollServerDomainSocketChannel;
import alluxio.shaded.client.io.netty.channel.epoll.EpollServerSocketChannel;
import alluxio.shaded.client.io.netty.channel.epoll.EpollSocketChannel;
import alluxio.shaded.client.io.netty.channel.nio.NioEventLoopGroup;
import alluxio.shaded.client.io.netty.channel.socket.nio.NioServerSocketChannel;
import alluxio.shaded.client.io.netty.channel.socket.nio.NioSocketChannel;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.ThreadFactoryUtils;
import alluxio.util.io.FileUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class NettyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NettyUtils.class);
    private static Boolean sNettyEpollAvailable = null;

    private NettyUtils() {
    }

    public static EventLoopGroup createEventLoop(ChannelType type, int numThreads, String threadPrefix, boolean isDaemon) {
        ThreadFactory threadFactory = ThreadFactoryUtils.build(threadPrefix, isDaemon);
        switch (type) {
            case NIO: {
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
            case EPOLL: {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
        }
        throw new IllegalArgumentException("Unknown io type: " + (Object)((Object)type));
    }

    public static Class<? extends ServerChannel> getServerChannelClass(boolean isDomainSocket, AlluxioConfiguration conf) {
        ChannelType workerChannelType = NettyUtils.getWorkerChannel(conf);
        if (isDomainSocket) {
            Preconditions.checkState(workerChannelType == ChannelType.EPOLL, "Domain sockets are only supported with EPOLL channel type.");
            return EpollServerDomainSocketChannel.class;
        }
        switch (workerChannelType) {
            case NIO: {
                return NioServerSocketChannel.class;
            }
            case EPOLL: {
                return EpollServerSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io type: " + (Object)((Object)workerChannelType));
    }

    public static Class<? extends Channel> getClientChannelClass(boolean isDomainSocket, AlluxioConfiguration conf) {
        ChannelType userChannelType = NettyUtils.getUserChannel(conf);
        if (isDomainSocket) {
            Preconditions.checkState(userChannelType == ChannelType.EPOLL, "Domain sockets are only supported with EPOLL channel type.");
            return EpollDomainSocketChannel.class;
        }
        switch (userChannelType) {
            case NIO: {
                return NioSocketChannel.class;
            }
            case EPOLL: {
                return EpollSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io type: " + (Object)((Object)userChannelType));
    }

    public static void enableAutoRead(Channel channel) {
        if (!channel.config().isAutoRead()) {
            channel.config().setAutoRead(true);
            channel.read();
        }
    }

    public static void disableAutoRead(Channel channel) {
        channel.config().setAutoRead(false);
    }

    public static boolean isDomainSocketAccessible(WorkerNetAddress workerNetAddress, AlluxioConfiguration conf) {
        if (!NettyUtils.isDomainSocketSupported(workerNetAddress) || NettyUtils.getUserChannel(conf) != ChannelType.EPOLL) {
            return false;
        }
        if (conf.getBoolean(PropertyKey.WORKER_DATA_SERVER_DOMAIN_SOCKET_AS_UUID)) {
            return FileUtils.exists(workerNetAddress.getDomainSocketPath());
        }
        return workerNetAddress.getHost().equals(NetworkAddressUtils.getClientHostName(conf));
    }

    public static boolean isDomainSocketSupported(WorkerNetAddress workerNetAddress) {
        return !workerNetAddress.getDomainSocketPath().isEmpty();
    }

    public static synchronized boolean isNettyEpollAvailable() {
        if (sNettyEpollAvailable == null) {
            sNettyEpollAvailable = NettyUtils.checkNettyEpollAvailable();
        }
        return sNettyEpollAvailable;
    }

    private static boolean checkNettyEpollAvailable() {
        if (!Epoll.isAvailable()) {
            LOG.info("EPOLL is not available, will use NIO");
            return false;
        }
        try {
            EpollChannelOption.class.getField("EPOLL_MODE");
            LOG.info("EPOLL_MODE is available");
            return true;
        }
        catch (Throwable e) {
            LOG.warn("EPOLL_MODE is not supported in netty with version < 4.0.26.Final, will use NIO");
            return false;
        }
    }

    public static ChannelType getUserChannel(AlluxioConfiguration conf) {
        return NettyUtils.getChannelType(PropertyKey.USER_NETWORK_NETTY_CHANNEL, conf);
    }

    public static ChannelType getWorkerChannel(AlluxioConfiguration conf) {
        return NettyUtils.getChannelType(PropertyKey.WORKER_NETWORK_NETTY_CHANNEL, conf);
    }

    private static ChannelType getChannelType(PropertyKey key, AlluxioConfiguration conf) {
        if (!NettyUtils.isNettyEpollAvailable()) {
            return ChannelType.NIO;
        }
        return conf.getEnum(key, ChannelType.class);
    }
}

