/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.airlift.units;

import io.prestosql.jdbc.$internal.airlift.units.Preconditions;
import io.prestosql.jdbc.$internal.jackson.annotation.JsonCreator;
import io.prestosql.jdbc.$internal.jackson.annotation.JsonValue;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Duration
implements Comparable<Duration> {
    private static final Pattern PATTERN = Pattern.compile("^\\s*(\\d+(?:\\.\\d+)?)\\s*([a-zA-Z]+)\\s*$");
    private static final TimeUnit[] TIME_UNITS = TimeUnit.values();
    private final double value;
    private final TimeUnit unit;

    public static Duration nanosSince(long start) {
        return Duration.succinctNanos(System.nanoTime() - start);
    }

    public static Duration succinctNanos(long nanos) {
        return Duration.succinctDuration(nanos, TimeUnit.NANOSECONDS);
    }

    public static Duration succinctDuration(double value, TimeUnit unit) {
        return new Duration(value, unit).convertToMostSuccinctTimeUnit();
    }

    public Duration(double value, TimeUnit unit) {
        Preconditions.checkArgument(!Double.isInfinite(value), "value is infinite");
        Preconditions.checkArgument(!Double.isNaN(value), "value is not a number");
        Preconditions.checkArgument(value >= 0.0, "value is negative");
        Objects.requireNonNull(unit, "unit is null");
        this.value = value;
        this.unit = unit;
    }

    public long toMillis() {
        return this.roundTo(TimeUnit.MILLISECONDS);
    }

    public double getValue() {
        return this.value;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public double getValue(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "timeUnit is null");
        return this.value * (Duration.millisPerTimeUnit(this.unit) * 1.0 / Duration.millisPerTimeUnit(timeUnit));
    }

    public long roundTo(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "timeUnit is null");
        double rounded = Math.floor(this.getValue(timeUnit) + 0.5);
        Preconditions.checkArgument(rounded <= 9.223372036854776E18, "size is too large to be represented in requested unit as a long");
        return (long)rounded;
    }

    public Duration convertTo(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "timeUnit is null");
        return new Duration(this.getValue(timeUnit), timeUnit);
    }

    public Duration convertToMostSuccinctTimeUnit() {
        TimeUnit unitToUse = TimeUnit.NANOSECONDS;
        for (TimeUnit unitToTest : TIME_UNITS) {
            if (!(this.getValue(unitToTest) > 0.9999)) break;
            unitToUse = unitToTest;
        }
        return this.convertTo(unitToUse);
    }

    @JsonValue
    public String toString() {
        return this.toString(this.unit);
    }

    public String toString(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "timeUnit is null");
        double magnitude = this.getValue(timeUnit);
        String timeUnitAbbreviation = Duration.timeUnitToString(timeUnit);
        return String.format(Locale.ENGLISH, "%.2f%s", magnitude, timeUnitAbbreviation);
    }

    @JsonCreator
    public static Duration valueOf(String duration) throws IllegalArgumentException {
        Objects.requireNonNull(duration, "duration is null");
        Preconditions.checkArgument(!duration.isEmpty(), "duration is empty");
        Matcher matcher = PATTERN.matcher(duration);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("duration is not a valid data duration string: " + duration);
        }
        double value = Double.parseDouble(matcher.group(1));
        String unitString = matcher.group(2);
        TimeUnit timeUnit = Duration.valueOfTimeUnit(unitString);
        return new Duration(value, timeUnit);
    }

    @Override
    public int compareTo(Duration o) {
        return Double.compare(this.getValue(TimeUnit.MILLISECONDS), o.getValue(TimeUnit.MILLISECONDS));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        return this.compareTo(duration) == 0;
    }

    public int hashCode() {
        double value = this.getValue(TimeUnit.MILLISECONDS);
        return Double.hashCode(value);
    }

    public static TimeUnit valueOfTimeUnit(String timeUnitString) {
        Objects.requireNonNull(timeUnitString, "timeUnitString is null");
        switch (timeUnitString) {
            case "ns": {
                return TimeUnit.NANOSECONDS;
            }
            case "us": {
                return TimeUnit.MICROSECONDS;
            }
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "d": {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("Unknown time unit: " + timeUnitString);
    }

    public static String timeUnitToString(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "timeUnit is null");
        switch (timeUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new IllegalArgumentException("Unsupported time unit " + (Object)((Object)timeUnit));
    }

    private static double millisPerTimeUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return 1.0E-6;
            }
            case MICROSECONDS: {
                return 0.001;
            }
            case MILLISECONDS: {
                return 1.0;
            }
            case SECONDS: {
                return 1000.0;
            }
            case MINUTES: {
                return 60000.0;
            }
            case HOURS: {
                return 3600000.0;
            }
            case DAYS: {
                return 8.64E7;
            }
        }
        throw new IllegalArgumentException("Unsupported time unit " + (Object)((Object)timeUnit));
    }
}

