/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.jackson.datatype.guava;

import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.guava.collect.BoundType;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableCollection;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableList;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableMap;
import io.prestosql.jdbc.$internal.guava.collect.ImmutableSet;
import io.prestosql.jdbc.$internal.guava.net.HostAndPort;
import io.prestosql.jdbc.$internal.jackson.databind.BeanDescription;
import io.prestosql.jdbc.$internal.jackson.databind.DeserializationConfig;
import io.prestosql.jdbc.$internal.jackson.databind.JavaType;
import io.prestosql.jdbc.$internal.jackson.databind.JsonDeserializer;
import io.prestosql.jdbc.$internal.jackson.databind.JsonMappingException;
import io.prestosql.jdbc.$internal.jackson.databind.KeyDeserializer;
import io.prestosql.jdbc.$internal.jackson.databind.deser.Deserializers;
import io.prestosql.jdbc.$internal.jackson.databind.jsontype.TypeDeserializer;
import io.prestosql.jdbc.$internal.jackson.databind.type.CollectionType;
import io.prestosql.jdbc.$internal.jackson.databind.type.MapLikeType;
import io.prestosql.jdbc.$internal.jackson.databind.type.MapType;
import io.prestosql.jdbc.$internal.jackson.databind.type.ReferenceType;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.GuavaOptionalDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.HashCodeDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.HashMultisetDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.HostAndPortDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.ImmutableBiMapDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.ImmutableListDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.ImmutableMapDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.ImmutableMultisetDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.ImmutableSetDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.ImmutableSortedMapDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.ImmutableSortedMultisetDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.ImmutableSortedSetDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.InternetDomainNameDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.LinkedHashMultisetDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.RangeDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.TreeMultisetDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.multimap.list.ArrayListMultimapDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.multimap.list.LinkedListMultimapDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.multimap.set.HashMultimapDeserializer;
import io.prestosql.jdbc.$internal.jackson.datatype.guava.deser.multimap.set.LinkedHashMultimapDeserializer;
import java.io.Serializable;

public class GuavaDeserializers
extends Deserializers.Base
implements Serializable {
    static final long serialVersionUID = 1L;
    protected BoundType _defaultBoundType;

    public GuavaDeserializers() {
        this(null);
    }

    public GuavaDeserializers(BoundType defaultBoundType) {
        this._defaultBoundType = defaultBoundType;
    }

    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ImmutableCollection.class.isAssignableFrom(raw)) {
            if (ImmutableList.class.isAssignableFrom(raw)) {
                return new ImmutableListDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (.ImmutableMultiset.class.isAssignableFrom(raw)) {
                if (.ImmutableSortedMultiset.class.isAssignableFrom(raw)) {
                    this.requireCollectionOfComparableElements(type, "ImmutableSortedMultiset");
                    return new ImmutableSortedMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
                }
                return new ImmutableMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (ImmutableSet.class.isAssignableFrom(raw)) {
                if (.ImmutableSortedSet.class.isAssignableFrom(raw)) {
                    this.requireCollectionOfComparableElements(type, "ImmutableSortedSet");
                    return new ImmutableSortedSetDeserializer(type, elementTypeDeserializer, elementDeserializer);
                }
                return new ImmutableSetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            return new ImmutableListDeserializer(type, elementTypeDeserializer, elementDeserializer);
        }
        if (.Multiset.class.isAssignableFrom(raw)) {
            if (.SortedMultiset.class.isAssignableFrom(raw)) {
                if (.TreeMultiset.class.isAssignableFrom(raw)) {
                    return new TreeMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
                }
                return new TreeMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (.LinkedHashMultiset.class.isAssignableFrom(raw)) {
                return new LinkedHashMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (.HashMultiset.class.isAssignableFrom(raw)) {
                return new HashMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (.EnumMultiset.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new HashMultisetDeserializer(type, elementTypeDeserializer, elementDeserializer);
        }
        return null;
    }

    private void requireCollectionOfComparableElements(CollectionType actualType, String targetType) {
        Class<?> elemType = actualType.getContentType().getRawClass();
        if (!Comparable.class.isAssignableFrom(elemType)) {
            throw new IllegalArgumentException("Can not handle " + targetType + " with elements that are not Comparable<?> (" + elemType.getName() + ")");
        }
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (ImmutableMap.class.isAssignableFrom(raw)) {
            if (.ImmutableSortedMap.class.isAssignableFrom(raw)) {
                return new ImmutableSortedMapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (.ImmutableBiMap.class.isAssignableFrom(raw)) {
                return new ImmutableBiMapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            return new ImmutableMapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (.BiMap.class.isAssignableFrom(raw)) {
            if (.EnumBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (.EnumHashBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (.HashBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (.ListMultimap.class.isAssignableFrom(raw)) {
            if (.ImmutableListMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (.ArrayListMultimap.class.isAssignableFrom(raw)) {
                return new ArrayListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (.LinkedListMultimap.class.isAssignableFrom(raw)) {
                return new LinkedListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (.ForwardingListMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new ArrayListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (.SetMultimap.class.isAssignableFrom(raw)) {
            if (.SortedSetMultimap.class.isAssignableFrom(raw)) {
                if (.TreeMultimap.class.isAssignableFrom(raw)) {
                    // empty if block
                }
                if (.ForwardingSortedSetMultimap.class.isAssignableFrom(raw)) {
                    // empty if block
                }
            }
            if (.ImmutableSetMultimap.class.isAssignableFrom(raw)) {
                return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (.HashMultimap.class.isAssignableFrom(raw)) {
                return new HashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (.LinkedHashMultimap.class.isAssignableFrom(raw)) {
                return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (.ForwardingSetMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new HashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (.Multimap.class.isAssignableFrom(raw)) {
            return new LinkedListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (.Table.class.isAssignableFrom(raw)) {
            // empty if block
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) {
        if (refType.hasRawClass(.Optional.class)) {
            return new GuavaOptionalDeserializer(refType, null, contentTypeDeserializer, contentDeserializer);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) {
        if (type.hasRawClass(.Range.class)) {
            return new RangeDeserializer(this._defaultBoundType, type);
        }
        if (type.hasRawClass(HostAndPort.class)) {
            return HostAndPortDeserializer.std;
        }
        if (type.hasRawClass(.InternetDomainName.class)) {
            return InternetDomainNameDeserializer.std;
        }
        if (type.hasRawClass(.HashCode.class)) {
            return HashCodeDeserializer.std;
        }
        return null;
    }
}

