/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.jackson.datatype.guava.deser;

import io.prestosql.jdbc.$internal.guava.net.HostAndPort;
import io.prestosql.jdbc.$internal.jackson.core.JsonParser;
import io.prestosql.jdbc.$internal.jackson.core.JsonToken;
import io.prestosql.jdbc.$internal.jackson.databind.DeserializationContext;
import io.prestosql.jdbc.$internal.jackson.databind.JsonNode;
import io.prestosql.jdbc.$internal.jackson.databind.deser.std.FromStringDeserializer;
import java.io.IOException;

public class HostAndPortDeserializer
extends FromStringDeserializer<HostAndPort> {
    private static final long serialVersionUID = 1L;
    public static final HostAndPortDeserializer std = new HostAndPortDeserializer();

    public HostAndPortDeserializer() {
        super(HostAndPort.class);
    }

    @Override
    public HostAndPort deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            JsonNode root = (JsonNode)jp.readValueAsTree();
            String host = root.path("hostText").asText();
            JsonNode n = root.get("port");
            if (n == null) {
                return HostAndPort.fromString(host);
            }
            return HostAndPort.fromParts(host, n.asInt());
        }
        return (HostAndPort)super.deserialize(jp, ctxt);
    }

    @Override
    protected HostAndPort _deserialize(String value, DeserializationContext ctxt) throws IOException {
        return HostAndPort.fromString(value);
    }
}

