/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import io.prestosql.jdbc.$internal.guava.base.Joiner;
import io.prestosql.jdbc.$internal.guava.io.BaseEncoding;
import io.prestosql.jdbc.$internal.guava.primitives.Ints;
import io.prestosql.jdbc.NotImplementedException;
import io.prestosql.jdbc.ObjectCasts;
import io.prestosql.jdbc.PrestoConnection;
import io.prestosql.jdbc.PrestoResultSet;
import io.prestosql.jdbc.PrestoStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PrestoPreparedStatement
extends PrestoStatement
implements PreparedStatement {
    private final Map<Integer, String> parameters = new HashMap<Integer, String>();
    private final String statementName;
    private final String originalSql;

    PrestoPreparedStatement(PrestoConnection connection, String statementName, String sql) throws SQLException {
        super(connection);
        this.statementName = Objects.requireNonNull(statementName, "statementName is null");
        this.originalSql = Objects.requireNonNull(sql, "sql is null");
        super.execute(String.format("PREPARE %s FROM %s", statementName, sql));
    }

    @Override
    public void close() throws SQLException {
        super.execute(String.format("DEALLOCATE PREPARE %s", this.statementName));
        super.close();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!super.execute(this.getExecuteSql())) {
            throw new SQLException("Prepared SQL statement is not a query: " + this.originalSql);
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return Ints.saturatedCast(this.executeLargeUpdate());
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        if (super.execute(this.getExecuteSql())) {
            throw new SQLException("Prepared SQL is not an update statement: " + this.originalSql);
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.getExecuteSql());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, PrestoPreparedStatement.typedNull(sqlType));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, PrestoPreparedStatement.formatBooleanLiteral(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, PrestoPreparedStatement.formatLiteral("TINYINT", Byte.toString(x)));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, PrestoPreparedStatement.formatLiteral("SMALLINT", Short.toString(x)));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, PrestoPreparedStatement.formatLiteral("INTEGER", Integer.toString(x)));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, PrestoPreparedStatement.formatLiteral("BIGINT", Long.toString(x)));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, PrestoPreparedStatement.formatLiteral("REAL", Float.toString(x)));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, PrestoPreparedStatement.formatLiteral("DOUBLE", Double.toString(x)));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.setParameter(parameterIndex, PrestoPreparedStatement.formatLiteral("DECIMAL", x.toString()));
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setParameter(parameterIndex, PrestoPreparedStatement.formatStringLiteral(x));
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, -3);
        } else {
            this.setParameter(parameterIndex, PrestoPreparedStatement.formatBinaryLiteral(x));
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            this.setParameter(parameterIndex, PrestoPreparedStatement.formatLiteral("DATE", PrestoResultSet.DATE_FORMATTER.print(x.getTime())));
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            this.setParameter(parameterIndex, PrestoPreparedStatement.formatLiteral("TIME", PrestoResultSet.TIME_FORMATTER.print(x.getTime())));
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            this.setParameter(parameterIndex, PrestoPreparedStatement.formatLiteral("TIMESTAMP", PrestoResultSet.TIMESTAMP_FORMATTER.print(x.getTime())));
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setAsciiStream");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setUnicodeStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setBinaryStream");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        this.parameters.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case -7: 
            case 16: {
                this.setBoolean(parameterIndex, ObjectCasts.castToBoolean(x, targetSqlType));
                return;
            }
            case -6: {
                this.setByte(parameterIndex, ObjectCasts.castToByte(x, targetSqlType));
                return;
            }
            case 5: {
                this.setShort(parameterIndex, ObjectCasts.castToShort(x, targetSqlType));
                return;
            }
            case 4: {
                this.setInt(parameterIndex, ObjectCasts.castToInt(x, targetSqlType));
                return;
            }
            case -5: {
                this.setLong(parameterIndex, ObjectCasts.castToLong(x, targetSqlType));
                return;
            }
            case 6: 
            case 7: {
                this.setFloat(parameterIndex, ObjectCasts.castToFloat(x, targetSqlType));
                return;
            }
            case 8: {
                this.setDouble(parameterIndex, ObjectCasts.castToDouble(x, targetSqlType));
                return;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, ObjectCasts.castToBigDecimal(x, targetSqlType));
                return;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, x.toString());
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(parameterIndex, ObjectCasts.castToBinary(x, targetSqlType));
                return;
            }
            case 91: {
                this.setDate(parameterIndex, ObjectCasts.castToDate(x, targetSqlType));
                return;
            }
            case 92: {
                this.setTime(parameterIndex, ObjectCasts.castToTime(x, targetSqlType));
                return;
            }
            case 93: {
                this.setTimestamp(parameterIndex, ObjectCasts.castToTimestamp(x, targetSqlType));
                return;
            }
        }
        throw new SQLException("Unsupported target SQL type: " + targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber());
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            throw new SQLException("Unsupported object type: " + x.getClass().getName());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        throw new NotImplementedException("PreparedStatement", "addBatch");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setCharacterStream");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRef");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setArray");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("getMetaData");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setDate");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setTime");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setTimestamp");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setURL");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new NotImplementedException("PreparedStatement", "getParameterMetaData");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRowId");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNCharacterStream");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSQLXML");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("setObject");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setCharacterStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNCharacterStream");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    private void setParameter(int parameterIndex, String value) throws SQLException {
        if (parameterIndex < 1) {
            throw new SQLException("Parameter index out of bounds: " + parameterIndex);
        }
        this.parameters.put(parameterIndex - 1, value);
    }

    private void formatParametersTo(StringBuilder builder) throws SQLException {
        ArrayList<String> values = new ArrayList<String>();
        for (int index = 0; index < this.parameters.size(); ++index) {
            if (!this.parameters.containsKey(index)) {
                throw new SQLException("No value specified for parameter " + (index + 1));
            }
            values.add(this.parameters.get(index));
        }
        Joiner.on(", ").appendTo(builder, (Iterable<?>)values);
    }

    private String getExecuteSql() throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("EXECUTE ").append(this.statementName);
        if (!this.parameters.isEmpty()) {
            sql.append(" USING ");
            this.formatParametersTo(sql);
        }
        return sql.toString();
    }

    private static String formatLiteral(String type, String x) {
        return type + " " + PrestoPreparedStatement.formatStringLiteral(x);
    }

    private static String formatBooleanLiteral(boolean x) {
        return Boolean.toString(x);
    }

    private static String formatStringLiteral(String x) {
        return "'" + x.replace("'", "''") + "'";
    }

    private static String formatBinaryLiteral(byte[] x) {
        return "X'" + BaseEncoding.base16().encode(x) + "'";
    }

    private static String typedNull(int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -7: 
            case 16: {
                return PrestoPreparedStatement.typedNull("BOOLEAN");
            }
            case -6: {
                return PrestoPreparedStatement.typedNull("TINYINT");
            }
            case 5: {
                return PrestoPreparedStatement.typedNull("SMALLINT");
            }
            case 4: {
                return PrestoPreparedStatement.typedNull("INTEGER");
            }
            case -5: {
                return PrestoPreparedStatement.typedNull("BIGINT");
            }
            case 6: 
            case 7: {
                return PrestoPreparedStatement.typedNull("REAL");
            }
            case 8: {
                return PrestoPreparedStatement.typedNull("DOUBLE");
            }
            case 2: 
            case 3: {
                return PrestoPreparedStatement.typedNull("DECIMAL");
            }
            case -15: 
            case 1: {
                return PrestoPreparedStatement.typedNull("CHAR");
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: 
            case 2005: 
            case 2011: {
                return PrestoPreparedStatement.typedNull("VARCHAR");
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return PrestoPreparedStatement.typedNull("VARBINARY");
            }
            case 91: {
                return PrestoPreparedStatement.typedNull("DATE");
            }
            case 92: {
                return PrestoPreparedStatement.typedNull("TIME");
            }
            case 93: {
                return PrestoPreparedStatement.typedNull("TIMESTAMP");
            }
            case 0: {
                return "NULL";
            }
        }
        throw new SQLException("Unsupported target SQL type: " + targetSqlType);
    }

    private static String typedNull(String prestoType) {
        return String.format("CAST(NULL AS %s)", prestoType);
    }
}

