/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.client.Warning;
import io.prestosql.jdbc.PrestoSqlWarning;
import java.sql.SQLWarning;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@.ThreadSafe
public class WarningsManager {
    @.GuardedBy(value="this")
    private final Set<Warning.Code> warningsSeen = new HashSet<Warning.Code>();
    @.GuardedBy(value="this")
    private SQLWarning firstWarning;
    @.GuardedBy(value="this")
    private SQLWarning lastWarning;

    private synchronized void addWarning(Warning warning) {
        Objects.requireNonNull(warning, "warning is null");
        if (this.lastWarning == null) {
            this.lastWarning = new PrestoSqlWarning(warning);
        } else {
            this.lastWarning.setNextWarning(new PrestoSqlWarning(warning));
        }
        if (this.firstWarning == null) {
            this.firstWarning = this.lastWarning;
        } else {
            this.lastWarning = this.lastWarning.getNextWarning();
        }
    }

    public synchronized void addWarnings(List<Warning> warnings) {
        for (Warning warning : warnings) {
            if (!this.warningsSeen.add(warning.getWarningCode())) continue;
            this.addWarning(warning);
        }
    }

    public synchronized SQLWarning getWarnings() {
        return this.firstWarning;
    }

    public synchronized void clearWarnings() {
        this.firstWarning = null;
        this.lastWarning = null;
    }
}

